/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.BiomeChunk;
import fionathemortal.betterbiomeblend.ColorBlending;
import fionathemortal.betterbiomeblend.ColorCaching;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

public final class BiomeCache {
    public final ReentrantLock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<BiomeChunk> hash;
    public final Stack<BiomeChunk> free;

    public BiomeCache(int count) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.free = new Stack();
        for (int index = 0; index < count; ++index) {
            this.free.add(new BiomeChunk());
        }
    }

    public void releaseChunkWithoutLock(BiomeChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.free.push(chunk);
        }
    }

    public void releaseChunk(BiomeChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.lock.lock();
            this.free.push(chunk);
            this.lock.unlock();
        }
    }

    public void invalidateAll() {
        this.lock.lock();
        for (BiomeChunk chunk : this.hash.values()) {
            this.releaseChunkWithoutLock(chunk);
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.lock.unlock();
    }

    public void invalidateSmallNeighborhood(int chunkX, int chunkZ) {
        this.lock.lock();
        for (int chunkIndex = 0; chunkIndex < 9; ++chunkIndex) {
            BiomeChunk chunk;
            int offsetX = ColorBlending.getNeighborOffsetX(chunkIndex);
            int offsetZ = ColorBlending.getNeighborOffsetZ(chunkIndex);
            long key = ColorCaching.getChunkKey(chunkX + offsetX, chunkZ + offsetZ, 0);
            if (chunkIndex == 0) {
                chunk = (BiomeChunk)this.hash.remove(key);
                if (chunk == null) continue;
                this.releaseChunkWithoutLock(chunk);
                chunk.markAsInvalid();
                continue;
            }
            chunk = (BiomeChunk)this.hash.get(key);
            if (chunk == null) continue;
            int minX = ColorBlending.getNeighborRectMinX(chunkIndex, 2);
            int minZ = ColorBlending.getNeighborRectMinZ(chunkIndex, 2);
            int maxX = ColorBlending.getNeighborRectMaxX(chunkIndex, 2);
            int maxZ = ColorBlending.getNeighborRectMaxZ(chunkIndex, 2);
            for (int z1 = minZ; z1 < maxZ; ++z1) {
                for (int x1 = minX; x1 < maxX; ++x1) {
                    chunk.data[16 * z1 + x1] = null;
                }
            }
        }
        this.lock.unlock();
    }

    public BiomeChunk getOrDefaultInitializeChunk(int chunkX, int chunkZ) {
        long key = ColorCaching.getChunkKey(chunkX, chunkZ, 0);
        this.lock.lock();
        BiomeChunk result = (BiomeChunk)this.hash.getAndMoveToFirst(key);
        if (result == null) {
            if (!this.free.empty()) {
                result = this.free.pop();
            } else {
                while (true) {
                    long lastKey = this.hash.lastLongKey();
                    result = (BiomeChunk)this.hash.removeLast();
                    if (result.getReferenceCount() == 1) {
                        result.release();
                        break;
                    }
                    this.hash.putAndMoveToFirst(lastKey, (Object)result);
                }
            }
            result.key = key;
            Arrays.fill(result.data, null);
            result.acquire();
            this.hash.putAndMoveToFirst(result.key, (Object)result);
        }
        result.acquire();
        this.lock.unlock();
        return result;
    }
}

