/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.ColorCaching;
import fionathemortal.betterbiomeblend.ColorChunk;
import fionathemortal.betterbiomeblend.CustomColorResolverCompatibility;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

public final class BlendCache {
    public final ReentrantLock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<ColorChunk> hash;
    public final Stack<ColorChunk> freeStack;
    public final ArrayList<ColorChunk> generating;
    public int invalidationCounter = 0;

    public BlendCache(int count) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.freeStack = new Stack();
        this.generating = new ArrayList();
        for (int index = 0; index < count; ++index) {
            this.freeStack.add(new ColorChunk());
        }
    }

    public void releaseChunkWithoutLock(ColorChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.freeStack.push(chunk);
        }
    }

    public void releaseChunk(ColorChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.lock.lock();
            this.freeStack.push(chunk);
            this.lock.unlock();
        }
    }

    public void invalidateChunk(int chunkX, int chunkZ) {
        this.lock.lock();
        ++this.invalidationCounter;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int colorType = 0; colorType < CustomColorResolverCompatibility.nextColorResolverID; ++colorType) {
                    long key = ColorCaching.getChunkKey(chunkX + x, chunkZ + z, colorType);
                    ColorChunk chunk = (ColorChunk)this.hash.remove(key);
                    if (chunk != null) {
                        this.releaseChunkWithoutLock(chunk);
                        chunk.markAsInvalid();
                        continue;
                    }
                    ListIterator<ColorChunk> iterator = this.generating.listIterator();
                    while (iterator.hasNext()) {
                        ColorChunk generatingChunk = iterator.next();
                        if (generatingChunk.key != key) continue;
                        generatingChunk.markAsInvalid();
                        iterator.remove();
                    }
                }
            }
        }
        this.lock.unlock();
    }

    public void invalidateAll() {
        this.lock.lock();
        ++this.invalidationCounter;
        for (ColorChunk chunk : this.hash.values()) {
            this.releaseChunkWithoutLock(chunk);
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.lock.unlock();
    }

    public ColorChunk getChunk(int chunkX, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkZ, colorType);
        this.lock.lock();
        ColorChunk result = (ColorChunk)this.hash.getAndMoveToFirst(key);
        if (result != null) {
            result.acquire();
        }
        this.lock.unlock();
        return result;
    }

    public ColorChunk newChunk(int chunkX, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkZ, colorType);
        this.lock.lock();
        ColorChunk result = null;
        if (!this.freeStack.empty()) {
            result = this.freeStack.pop();
        } else {
            while (true) {
                long lastKey = this.hash.lastLongKey();
                result = (ColorChunk)this.hash.removeLast();
                if (result.getReferenceCount() == 1) {
                    result.release();
                    break;
                }
                this.hash.putAndMoveToFirst(lastKey, (Object)result);
            }
        }
        result.key = key;
        result.invalidationCounter = this.invalidationCounter;
        result.acquire();
        this.generating.add(result);
        this.lock.unlock();
        return result;
    }

    public ColorChunk putChunk(ColorChunk chunk) {
        ColorChunk result = chunk;
        this.lock.lock();
        if (this.generating.remove(chunk)) {
            ColorChunk prev = (ColorChunk)this.hash.getAndMoveToFirst(chunk.key);
            if (prev == null) {
                this.hash.putAndMoveToFirst(chunk.key, (Object)chunk);
                chunk.acquire();
            } else {
                ColorChunk olderChunk;
                if (chunk.invalidationCounter >= prev.invalidationCounter) {
                    olderChunk = prev;
                    this.hash.put(chunk.key, (Object)chunk);
                    chunk.acquire();
                } else {
                    olderChunk = chunk;
                    result = prev;
                    result.acquire();
                }
                this.releaseChunkWithoutLock(olderChunk);
                olderChunk.markAsInvalid();
            }
        }
        this.lock.unlock();
        return result;
    }
}

