/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend;

import fionathemortal.betterbiomeblend.ColorBlending;
import fionathemortal.betterbiomeblend.ColorCaching;
import fionathemortal.betterbiomeblend.ColorChunk;
import fionathemortal.betterbiomeblend.CustomColorResolverCompatibility;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;

public final class ColorCache {
    public final ReentrantLock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<ColorChunk> hash;
    public final Stack<ColorChunk> free;

    public ColorCache(int count) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.free = new Stack();
        for (int index = 0; index < count; ++index) {
            this.free.add(new ColorChunk());
        }
    }

    public void releaseChunkWithoutLock(ColorChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.free.push(chunk);
        }
    }

    public void releaseChunk(ColorChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.lock.lock();
            this.free.push(chunk);
            this.lock.unlock();
        }
    }

    public void invalidateAll() {
        this.lock.lock();
        for (ColorChunk chunk : this.hash.values()) {
            this.releaseChunkWithoutLock(chunk);
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.lock.unlock();
    }

    public void invalidateSmallNeighborhood(int chunkX, int chunkZ) {
        this.lock.lock();
        for (int chunkIndex = 0; chunkIndex < 9; ++chunkIndex) {
            int offsetX = ColorBlending.getNeighborOffsetX(chunkIndex);
            int offsetZ = ColorBlending.getNeighborOffsetZ(chunkIndex);
            for (int colorType = 0; colorType < CustomColorResolverCompatibility.nextColorResolverID; ++colorType) {
                ColorChunk chunk;
                long key = ColorCaching.getChunkKey(chunkX + offsetX, chunkZ + offsetZ, colorType);
                if (chunkIndex == 0) {
                    chunk = (ColorChunk)this.hash.remove(key);
                    if (chunk == null) continue;
                    this.releaseChunkWithoutLock(chunk);
                    chunk.markAsInvalid();
                    continue;
                }
                chunk = (ColorChunk)this.hash.get(key);
                if (chunk == null) continue;
                int minX = ColorBlending.getNeighborRectMinX(chunkIndex, 2);
                int minZ = ColorBlending.getNeighborRectMinZ(chunkIndex, 2);
                int maxX = ColorBlending.getNeighborRectMaxX(chunkIndex, 2);
                int maxZ = ColorBlending.getNeighborRectMaxZ(chunkIndex, 2);
                for (int z1 = minZ; z1 < maxZ; ++z1) {
                    for (int x1 = minX; x1 < maxX; ++x1) {
                        chunk.data[3 * (16 * z1 + x1) + 0] = -1;
                        chunk.data[3 * (16 * z1 + x1) + 1] = -1;
                        chunk.data[3 * (16 * z1 + x1) + 2] = -1;
                    }
                }
            }
        }
        this.lock.unlock();
    }

    public ColorChunk getOrDefaultInitializeChunk(int chunkX, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkZ, colorType);
        this.lock.lock();
        ColorChunk result = (ColorChunk)this.hash.getAndMoveToFirst(key);
        if (result == null) {
            if (!this.free.empty()) {
                result = this.free.pop();
            } else {
                while (true) {
                    long lastKey = this.hash.lastLongKey();
                    result = (ColorChunk)this.hash.removeLast();
                    if (result.getReferenceCount() == 1) {
                        result.release();
                        break;
                    }
                    this.hash.putAndMoveToFirst(lastKey, (Object)result);
                }
            }
            result.key = key;
            Arrays.fill(result.data, (byte)-1);
            result.acquire();
            this.hash.putAndMoveToFirst(result.key, (Object)result);
        }
        result.acquire();
        this.lock.unlock();
        return result;
    }
}

