/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.gui.window;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import me.ichun.mods.hats.client.gui.WorkspaceHats;
import me.ichun.mods.hats.client.gui.window.element.ElementHatRender;
import me.ichun.mods.hats.client.gui.window.element.ElementHatsScrollView;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.sort.SortHandler;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTexture;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class WindowHatsList
extends Window<WorkspaceHats> {
    public WindowHatsList(WorkspaceHats parent) {
        super((IWindows)parent);
        this.setBorderSize(() -> this.renderMinecraftStyle() > 0 ? 6 : 3);
        this.disableBringToFront();
        this.disableDocking();
        this.disableDockStacking();
        this.disableUndocking();
        this.disableDrag();
        this.disableTitle();
        this.setId("windowHatsList");
        this.setView(new ViewHatsList(this));
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (((WorkspaceHats)this.parent).age <= Hats.configClient.guiAnimationTime) {
            float prog = (float)Math.sin(Math.toRadians(MathHelper.func_76131_a((float)(((float)((WorkspaceHats)this.parent).age + partialTick) / (float)Hats.configClient.guiAnimationTime), (float)0.0f, (float)1.0f) * 90.0f));
            float reverseProg = 1.0f - prog;
            this.posX = (int)(Math.floor((float)((WorkspaceHats)this.parent).getWidth() / 2.0f) + (Math.ceil((float)((WorkspaceHats)this.parent).getWidth() / 2.0f) + 2.0) * (double)reverseProg);
            if (((WorkspaceHats)this.parent).age == Hats.configClient.guiAnimationTime) {
                this.resize(((WorkspaceHats)this.parent).getMinecraft(), ((WorkspaceHats)this.parent).field_230708_k_, ((WorkspaceHats)this.parent).field_230709_l_);
            }
            ((WorkspaceHats)this.parent).windowSidebar.constraint.apply();
        }
        super.func_230430_a_(stack, mouseX, mouseY, partialTick);
    }

    public void tick() {
        super.tick();
        if (((WorkspaceHats)this.parent).age == Hats.configClient.guiAnimationTime + 1) {
            this.posX = (int)(Math.floor((float)((WorkspaceHats)this.parent).getWidth() / 2.0f) + (Math.ceil((float)((WorkspaceHats)this.parent).getWidth() / 2.0f) + 2.0) * 0.0);
            this.resize(((WorkspaceHats)this.parent).getMinecraft(), ((WorkspaceHats)this.parent).field_230708_k_, ((WorkspaceHats)this.parent).field_230709_l_);
            ((WorkspaceHats)this.parent).windowSidebar.constraint.apply();
        }
    }

    public void setScissor() {
        if (((WorkspaceHats)this.parent).age < Hats.configClient.guiAnimationTime) {
            RenderHelper.startGlScissor((int)this.getLeft(), (int)this.getTop(), (int)(this.width * 2), (int)this.height);
        } else {
            super.setScissor();
        }
    }

    public ViewHatsList getCurrentView() {
        return (ViewHatsList)this.currentView;
    }

    public int getMinWidth() {
        return 140;
    }

    public static class ViewHatsList
    extends View<WindowHatsList> {
        public static ResourceLocation TEX_SEARCH = new ResourceLocation("hats", "textures/icon/search.png");
        public ElementHatsScrollView list;
        public ElementTextField textField;

        public ViewHatsList(@Nonnull WindowHatsList parent) {
            super((Window)parent, "hats.gui.window.hatsList");
            int padding = 4;
            ElementTexture searchIcon = new ElementTexture((Fragment)this, TEX_SEARCH);
            searchIcon.setSize(16, 16);
            searchIcon.constraints().left((IConstrainable)this, Constraint.Property.Type.LEFT, padding).bottom((IConstrainable)this, Constraint.Property.Type.BOTTOM, padding);
            this.elements.add(searchIcon);
            this.textField = new ElementTextField((Fragment)this);
            this.textField.setId("search");
            this.textField.setResponder(this::updateSearch).setSize(70, 12);
            this.textField.constraints().left((IConstrainable)searchIcon, Constraint.Property.Type.RIGHT, 2).bottom((IConstrainable)searchIcon, Constraint.Property.Type.BOTTOM, 1).top((IConstrainable)searchIcon, Constraint.Property.Type.TOP, 1).width((IConstrainable)this, Constraint.Property.Type.WIDTH, 40);
            this.elements.add(this.textField);
            ElementScrollBar sv = new ElementScrollBar((Fragment)this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.constraints().top((IConstrainable)this, Constraint.Property.Type.TOP, padding).bottom((IConstrainable)searchIcon, Constraint.Property.Type.TOP, padding).right((IConstrainable)this, Constraint.Property.Type.RIGHT, padding);
            this.elements.add(sv);
            this.list = new ElementHatsScrollView((Fragment)this).setScrollVertical(sv);
            this.list.constraints().top((IConstrainable)this, Constraint.Property.Type.TOP, padding + 1).bottom((IConstrainable)searchIcon, Constraint.Property.Type.TOP, padding + 1).left((IConstrainable)this, Constraint.Property.Type.LEFT, padding + 1).right((IConstrainable)sv, Constraint.Property.Type.LEFT, padding + 1);
            this.elements.add(this.list);
            this.updateSearch("");
        }

        public void updateSearch(String query) {
            List<HatsSavedData.HatPart> hatPartSource = ((WorkspaceHats)this.getWorkspace()).getHatPartSource();
            SortHandler.sort(Hats.configClient.filterSorters, hatPartSource, query.isEmpty());
            if (!query.isEmpty()) {
                hatPartSource = hatPartSource.stream().filter(hatPart -> hatPart.has(query.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
            }
            this.list.elements.clear();
            HatsSavedData.HatPart entityPart = HatHandler.getHatPart(((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).hatEntity);
            for (HatsSavedData.HatPart part : hatPartSource) {
                HatsSavedData.HatPart hatPart2 = part.createCopy();
                if (((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).hatLauncher != null && ((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).usePlayerInventory()) {
                    hatPart2.minusByOne(entityPart);
                }
                ElementHatRender<ElementHatRender> hat = new ElementHatRender<ElementHatRender>((Fragment)this.list, hatPart2, hatPart2, btn -> {
                    ElementHatsScrollView scrollView = (ElementHatsScrollView)btn.parentFragment;
                    if (btn.toggleState) {
                        for (Element<?> element : scrollView.elements) {
                            if (element == btn) continue;
                            ((ElementHatRender)element).toggleState = false;
                        }
                        boolean notify = false;
                        if (btn.hatLevel.isNew) {
                            btn.hatLevel.isNew = false;
                            notify = true;
                        }
                        ((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).setNewHat(btn.hatOrigin.setModifier(btn.hatLevel), notify);
                    }
                });
                HatsSavedData.HatPart parentPart = ((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).hatLauncher != null ? HatHandler.getHatPart(((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).hatLauncher) : HatHandler.getHatPart(((WorkspaceHats)((WindowHatsList)this.parentFragment).parent).hatEntity);
                hat.setToggled(parentPart.name.equals(part.name));
                hat.setSize(50, 70);
                this.list.addElement((Element<?>)hat);
            }
            this.list.init();
            this.list.init();
        }
    }
}

