/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.capability;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.heat.HeatCapability;
import lehjr.numina.util.capabilities.heat.HeatItemWrapper;
import lehjr.numina.util.capabilities.heat.IHeatStorage;
import lehjr.numina.util.capabilities.inventory.modechanging.ModeChangingModularItem;
import lehjr.numina.util.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.render.IModelSpecNBT;
import lehjr.numina.util.capabilities.render.ModelSpecNBT;
import lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import lehjr.powersuits.client.render.PowerFistSpecNBT;
import lehjr.powersuits.config.MPSSettings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PowerFistCap
implements ICapabilityProvider {
    final ItemStack itemStack;
    final EquipmentSlotType targetSlot;
    final ModeChangingModularItem modularItem;
    final LazyOptional<IItemHandler> modularItemHolder;
    final ModelSpecNBT modelSpec;
    final LazyOptional<IModelSpecNBT> modelSpecHolder;
    final HeatItemWrapper heatStorage;
    final LazyOptional<IHeatStorage> heatHolder;
    final LazyOptional<IEnergyStorage> energyHolder;

    public PowerFistCap(@Nonnull ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
        this.targetSlot = EquipmentSlotType.MAINHAND;
        this.modularItem = new ModeChangingModularItem(this.itemStack, 40){
            {
                HashMap<ModuleCategory, NuminaRangedWrapper> rangedWrapperMap = new HashMap<ModuleCategory, NuminaRangedWrapper>();
                rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, this.getSlots()));
                this.setRangedWrapperMap(rangedWrapperMap);
            }
        };
        this.modularItemHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            return this.modularItem;
        });
        this.modelSpec = new PowerFistSpecNBT(this.itemStack);
        this.modelSpecHolder = LazyOptional.of(() -> this.modelSpec);
        this.heatStorage = new HeatItemWrapper(this.itemStack, MPSSettings.getMaxHeatPowerFist());
        this.heatHolder = LazyOptional.of(() -> {
            this.heatStorage.updateFromNBT();
            return this.heatStorage;
        });
        this.energyHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            return (IEnergyStorage)this.modularItem.getStackInSlot(1).getCapability(CapabilityEnergy.ENERGY).orElse((Object)new EnergyStorage(0));
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        LazyOptional modularItemCapability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.modularItemHolder);
        if (modularItemCapability.isPresent()) {
            return modularItemCapability;
        }
        LazyOptional modelSpecCapability = ModelSpecNBTCapability.RENDER.orEmpty(cap, this.modelSpecHolder);
        if (modelSpecCapability.isPresent()) {
            return modelSpecCapability;
        }
        LazyOptional heatCapability = HeatCapability.HEAT.orEmpty(cap, this.heatHolder);
        if (heatCapability.isPresent()) {
            return heatCapability;
        }
        LazyOptional energyCapability = CapabilityEnergy.ENERGY.orEmpty(cap, this.energyHolder);
        if (energyCapability.isPresent()) {
            return energyCapability;
        }
        return LazyOptional.empty();
    }
}

