/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.common;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.util.client.gui.clickable.ClickableButton;
import lehjr.numina.util.client.gui.frame.GUISpacer;
import lehjr.numina.util.client.gui.frame.MultiRectHolderFrame;
import lehjr.numina.util.client.gui.frame.RectHolderFrame;
import lehjr.numina.util.client.gui.gemoetry.IRect;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.math.Colour;
import lehjr.powersuits.client.gui.common.ModularItemTabToggleWidget;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModularItemSelectionFrame
extends MultiRectHolderFrame {
    IChanged changed;
    final EquipmentSlotType[] equipmentSlotTypes = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET, EquipmentSlotType.MAINHAND, EquipmentSlotType.OFFHAND};
    public ClickableButton creativeInstallButton;
    public final List<ModularItemTabToggleWidget> tabButtons = Lists.newArrayList();
    public ModularItemTabToggleWidget selectedTab = null;

    public ModularItemSelectionFrame() {
        this(EquipmentSlotType.HEAD);
    }

    public ModularItemSelectionFrame(EquipmentSlotType type) {
        super(false, true, 30.0, 0.0);
        this.addRect((IRect)new GUISpacer(30.0, 11.0));
        int i = 0;
        for (EquipmentSlotType slotType : this.equipmentSlotTypes) {
            final ModularItemTabToggleWidget widget = new ModularItemTabToggleWidget(slotType);
            this.tabButtons.add(widget);
            widget.setOnPressed(pressed -> {
                if (widget != this.selectedTab) {
                    this.selectedTab.setStateActive(false);
                    this.selectedTab = widget;
                    this.selectedTab.setStateActive(true);
                    this.onChanged();
                    this.disableContainerSlots();
                }
            });
            if (slotType == type) {
                this.selectedTab = widget;
                this.selectedTab.setStateActive(true);
            }
            this.addRect((IRect)new RectHolderFrame((IRect)widget, 30.0, 27.0, RectHolderFrame.RectPlacement.CENTER_RIGHT){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    return widget.mouseClicked(mouseX, mouseY, button);
                }

                public boolean mouseReleased(double mouseX, double mouseY, int button) {
                    return widget.mouseReleased(mouseX, mouseY, button);
                }

                public List<ITextComponent> getToolTip(int x, int y) {
                    return widget.getToolTip(x, y);
                }

                public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
                    super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
                    widget.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
                }
            });
            if (i < 5) {
                this.addRect((IRect)new GUISpacer(30.0, 3.0));
            } else {
                this.addRect((IRect)new GUISpacer(30.0, 3.0));
                this.creativeInstallButton = new ClickableButton((ITextComponent)new TranslationTextComponent("gui.powersuits.creative.install"), MusePoint2D.ZERO, false);
                this.creativeInstallButton.setHeight(18.0);
                this.creativeInstallButton.setWidth(30.0);
                this.creativeInstallButton.disableAndHide();
                this.creativeInstallButton.setEnabledBackground(Colour.LIGHT_GREY);
                this.creativeInstallButton.setDisabledBackground(Colour.RED);
                this.addRect((IRect)new RectHolderFrame((IRect)this.creativeInstallButton, 30.0, 27.0, RectHolderFrame.RectPlacement.CENTER_RIGHT){
                    List<ITextComponent> toolTip;
                    {
                        this.toolTip = new ArrayList<ITextComponent>(){
                            {
                                this.add(new TranslationTextComponent("gui.powersuits.creative.install.desc"));
                            }
                        };
                    }

                    public boolean mouseClicked(double mouseX, double mouseY, int button) {
                        return ModularItemSelectionFrame.this.creativeInstallButton.mouseClicked(mouseX, mouseY, button);
                    }

                    public boolean mouseReleased(double mouseX, double mouseY, int button) {
                        return ModularItemSelectionFrame.this.creativeInstallButton.mouseReleased(mouseX, mouseY, button);
                    }

                    public List<ITextComponent> getToolTip(int x, int y) {
                        if (ModularItemSelectionFrame.this.creativeInstallButton.containsPoint((double)x, (double)y)) {
                            return this.toolTip;
                        }
                        return null;
                    }

                    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float frameTime) {
                        super.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
                        ModularItemSelectionFrame.this.creativeInstallButton.func_230430_a_(matrixStack, mouseX, mouseY, frameTime);
                    }
                });
                this.doneAdding();
            }
            ++i;
        }
    }

    public ClickableButton getCreativeInstallButton() {
        return this.creativeInstallButton;
    }

    void disableContainerSlots() {
    }

    public ItemStack getModularItemOrEmpty() {
        return this.getSelectedTab().map(tab -> {
            ItemStack stack = this.getStack(tab.getSlotType());
            return this.getModularItemCapability(tab.getSlotType()).isPresent() ? stack : ItemStack.field_190927_a;
        }).orElse(ItemStack.field_190927_a);
    }

    public Optional<IModularItem> getModularItemCapability() {
        return this.getModularItemOrEmpty().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast);
    }

    public boolean playerHasModularItems() {
        return Arrays.stream(this.equipmentSlotTypes).filter(type -> this.getModularItemCapability((EquipmentSlotType)type).isPresent()).findFirst().isPresent();
    }

    Optional<IModularItem> getModularItemCapability(EquipmentSlotType type) {
        return this.getStack(type).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast);
    }

    @Nonnull
    ItemStack getStack(EquipmentSlotType type) {
        return this.getMinecraft().field_71439_g.func_184582_a(type);
    }

    public Optional<EquipmentSlotType> selectedType() {
        return this.getSelectedTab().map(tab -> tab.getSlotType());
    }

    public boolean selectedIsSlotHovered() {
        return this.getSelectedTab().map(tab -> tab.isHovered()).orElse(false);
    }

    public Optional<ModularItemTabToggleWidget> getSelectedTab() {
        if (this.selectedTab == null) {
            this.selectedTab = this.tabButtons.get(0);
            this.selectedTab.setStateActive(true);
        }
        for (ModularItemTabToggleWidget widget : this.tabButtons) {
            if (widget == this.selectedTab) continue;
            widget.setStateActive(false);
        }
        return Optional.ofNullable(this.selectedTab);
    }

    public void update(double mouseX, double mouseY) {
        super.update(mouseX, mouseY);
        this.getSelectedTab();
    }

    public void setOnChanged(IChanged changed) {
        this.changed = changed;
    }

    public void onChanged() {
        if (this.isEnabled() && this.isVisible()) {
            this.refreshRects();
            if (this.changed != null) {
                this.changed.onChanged();
            }
        }
    }

    public static interface IChanged {
        public void onChanged();
    }
}

