/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.gui.modding.cosmetic;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lehjr.numina.basemod.MuseLogger;
import lehjr.numina.network.NuminaPackets;
import lehjr.numina.network.packets.CosmeticInfoPacket;
import lehjr.numina.util.capabilities.render.IArmorModelSpecNBT;
import lehjr.numina.util.capabilities.render.IHandHeldModelSpecNBT;
import lehjr.numina.util.capabilities.render.IModelSpecNBT;
import lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import lehjr.numina.util.capabilities.render.modelspec.ModelPartSpec;
import lehjr.numina.util.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.util.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.util.capabilities.render.modelspec.SpecBase;
import lehjr.numina.util.capabilities.render.modelspec.TexturePartSpec;
import lehjr.numina.util.client.gui.GuiIcon;
import lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import lehjr.numina.util.client.render.MuseIconUtils;
import lehjr.numina.util.client.render.MuseRenderer;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.math.MuseMathUtils;
import lehjr.powersuits.client.gui.common.ModularItemSelectionFrame;
import lehjr.powersuits.client.gui.modding.cosmetic.ColourPickerFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public class PartSpecManipSubFrame
extends DrawableTile {
    public SpecBase model;
    public ColourPickerFrame colourframe;
    public ModularItemSelectionFrame itemSelector;
    public List<PartSpecBase> partSpecs;
    public boolean open;
    Minecraft minecraft;
    float zLevel;
    final double specHeight = 9.0;
    final double iconWidth = 8.0;

    public PartSpecManipSubFrame(SpecBase model, double left, double top, double right, double bottom, ColourPickerFrame colourframe, ModularItemSelectionFrame itemSelector, float zLevel) {
        super(left, top, right, bottom);
        this.model = model;
        this.colourframe = colourframe;
        this.itemSelector = itemSelector;
        this.refreshPartSpecs();
        this.open = true;
        this.zLevel = zLevel;
        this.minecraft = Minecraft.func_71410_x();
        this.setBackgroundColour(Colour.BLACK.withAlpha(0.1f));
    }

    public void drawBackground(MatrixStack matrixStack) {
    }

    public Optional<IModelSpecNBT> getRenderCapability() {
        return this.itemSelector.getModularItemOrEmpty().getCapability(ModelSpecNBTCapability.RENDER).filter(IModelSpecNBT.class::isInstance).map(IModelSpecNBT.class::cast);
    }

    public List<PartSpecBase> getPartSpecs() {
        return this.partSpecs;
    }

    public void refreshPartSpecs() {
        this.partSpecs = new ArrayList<PartSpecBase>();
        this.getRenderCapability().ifPresent(iModelSpecNBT -> {
            EquipmentSlotType slot = MobEntity.func_184640_d((ItemStack)iModelSpecNBT.getItemStack());
            if (iModelSpecNBT instanceof IArmorModelSpecNBT) {
                this.model.getPartSpecs().forEach(spec -> {
                    if (spec.getBinding().getSlot().equals((Object)slot)) {
                        this.partSpecs.add((PartSpecBase)spec);
                    }
                });
            } else if (iModelSpecNBT instanceof IHandHeldModelSpecNBT) {
                this.model.getPartSpecs().forEach(spec -> {
                    if (spec.getBinding().getSlot().func_188453_a().equals((Object)EquipmentSlotType.Group.HAND)) {
                        this.partSpecs.add((PartSpecBase)spec);
                    }
                });
            }
        });
        if (!this.partSpecs.isEmpty()) {
            if (this.open) {
                this.setHeight(9.0 + 9.0 * (double)this.partSpecs.size());
            } else {
                this.setHeight(9.0);
            }
        }
    }

    @Nullable
    public CompoundNBT getOrDontGetSpecTag(PartSpecBase partSpec) {
        return this.getRenderCapability().map(iModelSpecNBT -> {
            CompoundNBT specTag = new CompoundNBT();
            CompoundNBT renderTag = iModelSpecNBT.getRenderTag();
            if (renderTag != null) {
                if (partSpec instanceof ModelPartSpec) {
                    String name = ModelRegistry.getInstance().makeName(partSpec);
                    CompoundNBT compoundNBT = specTag = renderTag.func_74764_b(name) ? renderTag.func_74775_l(name) : null;
                }
                if (partSpec instanceof TexturePartSpec && renderTag.func_74764_b("texSpec")) {
                    CompoundNBT texSpecTag = renderTag.func_74775_l("texSpec");
                    if (partSpec.spec.getOwnName().equals(texSpecTag.func_74779_i("model"))) {
                        specTag = renderTag.func_74775_l("texSpec");
                    }
                }
            }
            return specTag;
        }).orElse(new CompoundNBT());
    }

    public CompoundNBT getSpecTag(PartSpecBase partSpec) {
        CompoundNBT nbt = this.getOrDontGetSpecTag(partSpec);
        return nbt != null ? nbt : new CompoundNBT();
    }

    public CompoundNBT getOrMakeSpecTag(PartSpecBase partSpec) {
        CompoundNBT nbt = this.getSpecTag(partSpec);
        if (nbt.isEmpty()) {
            String name;
            if (partSpec instanceof ModelPartSpec) {
                name = ModelRegistry.getInstance().makeName(partSpec);
                ((ModelPartSpec)partSpec).multiSet(nbt, null, null);
            } else {
                name = "texSpec";
                partSpec.multiSet(nbt, null);
            }
            if (this.getRenderCapability() != null) {
                this.getRenderCapability().ifPresent(specNBT -> {
                    CompoundNBT renderTag = specNBT.getRenderTag();
                    if (renderTag != null && !renderTag.isEmpty()) {
                        renderTag.func_218657_a(name, (INBT)nbt);
                        specNBT.setRenderTag(renderTag, "render");
                    }
                });
            }
        }
        return nbt;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void drawPartial(MatrixStack matrixStack, double min, double max) {
        if (!this.partSpecs.isEmpty()) {
            MuseRenderer.drawShadowedString((MatrixStack)matrixStack, (String)this.model.getDisaplayName(), (double)(this.left() + 8.0), (double)this.top());
            this.drawOpenArrow(matrixStack, min, max);
            if (this.open) {
                int y = (int)(this.top() + 9.0);
                for (PartSpecBase spec : this.partSpecs) {
                    this.drawSpecPartial(matrixStack, this.left(), y, spec);
                    y = (int)((double)y + 9.0);
                }
            }
        }
    }

    public void decrAbove(int index) {
        for (PartSpecBase spec : this.partSpecs) {
            int oldindex;
            String tagname = ModelRegistry.getInstance().makeName(spec);
            CompoundNBT tagdata = this.getOrDontGetSpecTag(spec);
            if (tagdata == null || (oldindex = spec.getColourIndex(tagdata)) < index || oldindex <= 0) continue;
            spec.setColourIndex(tagdata, oldindex - 1);
            this.itemSelector.selectedType().ifPresent(slotType -> NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(slotType, tagname, tagdata)));
        }
    }

    public void drawSpecPartial(MatrixStack matrixStack, double x, double y, PartSpecBase partSpec) {
        GuiIcon icon = MuseIconUtils.getIcon();
        CompoundNBT tag = this.getSpecTag(partSpec);
        int selcomp = tag.isEmpty() ? 0 : (partSpec instanceof ModelPartSpec && ((ModelPartSpec)partSpec).getGlow(tag) ? 2 : 1);
        int selcolour = partSpec.getColourIndex(tag);
        icon.transparentArmor.draw(matrixStack, x, y, Colour.WHITE);
        icon.normalArmor.draw(matrixStack, x + 8.0, y, Colour.WHITE);
        if (partSpec instanceof ModelPartSpec) {
            icon.glowArmor.draw(matrixStack, x + 16.0, y, Colour.WHITE);
        }
        icon.selectedArmorOverlay.draw(matrixStack, x + (double)selcomp * 8.0, y, Colour.WHITE);
        double acc = x + 28.0;
        for (int colour : this.colourframe.colours()) {
            icon.armorColourPatch.draw(matrixStack, acc, y, new Colour(colour));
            acc += 8.0;
        }
        double textstartx = acc;
        if (selcomp > 0) {
            icon.selectedArmorOverlay.draw(matrixStack, x + 28.0 + (double)selcolour * 8.0, y, Colour.WHITE);
        }
        MuseRenderer.drawText((MatrixStack)matrixStack, (ITextComponent)partSpec.getDisaplayName(), (double)((float)textstartx + 4.0f), (double)((float)y), (Colour)Colour.WHITE);
    }

    public void drawOpenArrow(MatrixStack matrixStack, double min, double max) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_227850_m_);
        if (this.open) {
            buffer.func_227888_a_(matrix4f, (float)this.left() + 3.0f, (float)MuseMathUtils.clampDouble((double)(this.top() + 3.0), (double)min, (double)max), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)this.left() + 5.0f, (float)MuseMathUtils.clampDouble((double)(this.top() + 7.0), (double)min, (double)max), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)this.left() + 7.0f, (float)MuseMathUtils.clampDouble((double)(this.top() + 3.0), (double)min, (double)max), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
        } else {
            buffer.func_227888_a_(matrix4f, (float)this.left() + 3.0f, (float)MuseMathUtils.clampDouble((double)(this.top() + 3.0), (double)min, (double)max), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)this.left() + 3.0f, (float)MuseMathUtils.clampDouble((double)(this.top() + 7.0), (double)min, (double)max), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)this.left() + 7.0f, (float)MuseMathUtils.clampDouble((double)(this.top() + 5.0), (double)min, (double)max), this.zLevel).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public boolean tryMouseClick(double x, double y) {
        if (!this.containsPoint(x, y)) {
            return false;
        }
        if (x > this.left() + 2.0 && x < this.left() + 8.0 && y > this.top() + 2.0 && y < this.top() + 9.0) {
            this.open = !this.open;
            this.refreshPartSpecs();
            return true;
        }
        if (x < this.left() + 24.0 && y > this.top() + 9.0) {
            int lineNumber = (int)((y - this.top() - 9.0) / 9.0);
            int columnNumber = (int)((x - this.left()) / 8.0);
            PartSpecBase spec = this.partSpecs.get(Math.max(Math.min(lineNumber, this.partSpecs.size() - 1), 0));
            MuseLogger.logger.debug("Line " + lineNumber + " Column " + columnNumber);
            switch (columnNumber) {
                case 0: {
                    String tagname = spec instanceof TexturePartSpec ? "texSpec" : ModelRegistry.getInstance().makeName(spec);
                    this.itemSelector.selectedType().ifPresent(slotType -> NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(slotType, tagname, new CompoundNBT())));
                    this.refreshPartSpecs();
                    return true;
                }
                case 1: {
                    String tagname = spec instanceof TexturePartSpec ? "texSpec" : ModelRegistry.getInstance().makeName(spec);
                    CompoundNBT tagdata = this.getOrMakeSpecTag(spec);
                    if (spec instanceof ModelPartSpec) {
                        ((ModelPartSpec)spec).setGlow(tagdata, false);
                    }
                    this.itemSelector.selectedType().ifPresent(slotType -> NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(slotType, tagname, tagdata)));
                    this.refreshPartSpecs();
                    return true;
                }
                case 2: {
                    if (spec instanceof ModelPartSpec) {
                        String tagname = ModelRegistry.getInstance().makeName(spec);
                        CompoundNBT tagdata = this.getOrMakeSpecTag(spec);
                        ((ModelPartSpec)spec).setGlow(tagdata, true);
                        this.itemSelector.selectedType().ifPresent(slotType -> NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(slotType, tagname, tagdata)));
                        this.refreshPartSpecs();
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        if (x > this.left() + 28.0 && x < this.left() + 28.0 + (double)this.colourframe.colours().length * 8.0) {
            int lineNumber = (int)((y - this.top() - 9.0) / 9.0);
            int columnNumber = (int)((x - this.left() - 28.0) / 8.0);
            PartSpecBase spec = this.partSpecs.get(Math.max(Math.min(lineNumber, this.partSpecs.size() - 1), 0));
            String tagname = spec instanceof TexturePartSpec ? "texSpec" : ModelRegistry.getInstance().makeName(spec);
            CompoundNBT tagdata = this.getOrMakeSpecTag(spec);
            spec.setColourIndex(tagdata, columnNumber);
            this.itemSelector.selectedType().ifPresent(slotType -> NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(slotType, tagname, tagdata)));
            return true;
        }
        return false;
    }
}

