/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.client.model.item;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.network.NuminaPackets;
import lehjr.numina.network.packets.CosmeticInfoPacket;
import lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.util.capabilities.render.IHandHeldModelSpecNBT;
import lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import lehjr.numina.util.capabilities.render.modelspec.ModelPartSpec;
import lehjr.numina.util.capabilities.render.modelspec.ModelRegistry;
import lehjr.numina.util.capabilities.render.modelspec.ModelSpec;
import lehjr.numina.util.capabilities.render.modelspec.PartSpecBase;
import lehjr.numina.util.client.model.helper.ModelHelper;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.nbt.NBTTagAccessor;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.items.CapabilityItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class PowerFistModel
extends BakedModelWrapper {
    static ItemCameraTransforms.TransformType modelcameraTransformType;
    static ItemStack itemStack;
    static boolean isFiring;
    PlayerEntity player;

    public PowerFistModel(IBakedModel bakedModelIn) {
        super(bakedModelIn);
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return ImmutableList.of();
        }
        switch (modelcameraTransformType) {
            case GUI: 
            case FIXED: 
            case NONE: {
                return this.originalModel.getQuads(state, side, rand, extraData);
            }
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        itemStack.getCapability(ModelSpecNBTCapability.RENDER).ifPresent(specNBTCap -> {
            if (specNBTCap instanceof IHandHeldModelSpecNBT) {
                CompoundNBT renderSpec = specNBTCap.getRenderTag();
                if (!(renderSpec != null && !renderSpec.isEmpty() || (renderSpec = specNBTCap.getDefaultRenderTag()) == null || renderSpec.isEmpty() || modelcameraTransformType != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND && modelcameraTransformType != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)) {
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    EquipmentSlotType slotType = EquipmentSlotType.OFFHAND;
                    if (player.func_184614_ca().equals(itemStack)) {
                        slotType = EquipmentSlotType.MAINHAND;
                    }
                    specNBTCap.setRenderTag(renderSpec, "render");
                    NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CosmeticInfoPacket(slotType, "render", renderSpec));
                }
                if (renderSpec != null) {
                    int[] colours = renderSpec.func_74759_k("colours");
                    for (CompoundNBT nbt : NBTTagAccessor.getValues((CompoundNBT)renderSpec)) {
                        PartSpecBase partSpec = ModelRegistry.getInstance().getPart(nbt);
                        if (!(partSpec instanceof ModelPartSpec) || !partSpec.getBinding().getTarget().name().toUpperCase().equals(modelcameraTransformType.equals((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) || modelcameraTransformType.equals((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? "LEFTHAND" : "RIGHTHAND")) continue;
                        TransformationMatrix transform = ((ModelSpec)partSpec.spec).getTransform(modelcameraTransformType);
                        String itemState = partSpec.getBinding().getItemState();
                        int ix = partSpec.getColourIndex(nbt);
                        Colour partColor = ix < colours.length && ix >= 0 ? new Colour(colours[ix]) : Colour.WHITE;
                        boolean glow = ((ModelPartSpec)partSpec).getGlow(nbt);
                        if ((isFiring || !itemState.equals("all") && !itemState.equals("normal")) && (!isFiring || !itemState.equals("all") && !itemState.equals("firing"))) continue;
                        builder.addAll((Iterable)ModelHelper.getColouredQuadsWithGlowAndTransform((List)((ModelPartSpec)partSpec).getPart().getQuads(state, side, rand, extraData), (Colour)partColor, (TransformationMatrix)transform, (boolean)glow));
                    }
                }
            }
        });
        return builder.build();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        modelcameraTransformType = cameraTransformType;
        switch (cameraTransformType) {
            case FIRST_PERSON_LEFT_HAND: 
            case THIRD_PERSON_LEFT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_RIGHT_HAND: {
                return this;
            }
        }
        return super.handlePerspective(cameraTransformType, mat);
    }

    public void setPlayer(PlayerEntity player) {
        this.player = player;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public ItemOverrideList func_188617_f() {
        return new PowerFistItemOverrideList();
    }

    static {
        isFiring = false;
    }

    public class PowerFistItemOverrideList
    extends ItemOverrideList {
        @Nullable
        public IBakedModel func_239290_a_(IBakedModel originalModel, ItemStack itemStackIn, @Nullable ClientWorld world, @Nullable LivingEntity entityIn) {
            itemStack = itemStackIn;
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entityIn;
                if (player.func_184587_cr()) {
                    player.func_184586_b(player.func_184600_cs()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(modechanging -> {
                        if (!(modechanging instanceof IModeChangingItem)) {
                            return;
                        }
                        ItemStack module = ((IModeChangingItem)modechanging).getActiveModule();
                        int actualCount = 0;
                        int maxDuration = ((IModeChangingItem)modechanging).getModularItemStack().func_77988_m();
                        if (!module.func_190926_b()) {
                            actualCount = maxDuration - player.func_184605_cv();
                        }
                        isFiring = actualCount > 0;
                    });
                } else {
                    isFiring = false;
                }
            }
            return originalModel;
        }
    }
}

