/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.miningenhancement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AquaAffinityModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final BlockBreaker miningEnhancement;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new BlockBreaker(module, ModuleCategory.MINING_ENHANCEMENT, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("aquaEnergy", 0.0, "FE");
                    this.addBaseProperty("aquaHarvSpeed", 0.2f, "%");
                    this.addTradeoffProperty("aquaPower", "aquaEnergy", 1000.0);
                    this.addTradeoffProperty("aquaPower", "aquaHarvSpeed", 0.8f);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.miningEnhancement.updateFromNBT();
                return this.miningEnhancement;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class BlockBreaker
        extends MiningEnhancement
        implements IBlockBreakingModule {
            public BlockBreaker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean canHarvestBlock(@Nonnull ItemStack stack, BlockState state, PlayerEntity player, BlockPos pos, int playerEnergy) {
                return false;
            }

            public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                if (this.canHarvestBlock(itemStack, state, (PlayerEntity)entityLiving, pos, playerEnergy)) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)entityLiving, (int)this.getEnergyUsage());
                    return true;
                }
                return false;
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                PlayerEntity player = event.getPlayer();
                if (event.getNewSpeed() > 1.0f && (player.func_204231_K() || !player.func_233570_aj_()) && ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > this.getEnergyUsage()) {
                    event.setNewSpeed((float)((double)(event.getNewSpeed() * 5.0f) * this.applyPropertyModifiers("aquaHarvSpeed")));
                }
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("aquaEnergy");
            }

            @Nonnull
            public ItemStack getEmulatedTool() {
                return ItemStack.field_190927_a;
            }

            public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
                return false;
            }
        }
    }
}

