/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.miningenhancement;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.render.highlight.HighLightCapability;
import lehjr.numina.util.capabilities.render.highlight.Highlight;
import lehjr.numina.util.capabilities.render.highlight.IHighlight;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TunnelBoreModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Enhancement miningEnhancement;
        private final LazyOptional<IPowerModule> powerModuleHolder;
        private final Highlighter highlight;
        private final LazyOptional<IHighlight> highlightHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new Enhancement(module, ModuleCategory.MINING_ENHANCEMENT, ModuleTarget.TOOLONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("aoeEnergy", 500.0, "FE");
                    this.addTradeoffProperty("diameter", "aoeEnergy", 9500.0);
                    this.addIntTradeoffProperty("diameter", "aoeMiningDiameter", 5, "m", 2, 1);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.miningEnhancement.updateFromNBT();
                return this.miningEnhancement;
            });
            this.highlight = new Highlighter();
            this.highlightHolder = LazyOptional.of(() -> this.highlight);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            LazyOptional highlightCapability = HighLightCapability.HIGHLIGHT.orEmpty(capability, this.highlightHolder);
            if (highlightCapability.isPresent()) {
                return highlightCapability;
            }
            return LazyOptional.empty();
        }

        class Highlighter
        extends Highlight {
            Highlighter() {
            }

            public NonNullList<BlockPos> getBlockPositions(BlockRayTraceResult rayTraceResult) {
                NonNullList retList = NonNullList.func_191196_a();
                if (CapProvider.this.miningEnhancement.isModuleOnline()) {
                    Stream posList;
                    BlockPos pos = rayTraceResult.func_216350_a();
                    Direction side = rayTraceResult.func_216354_b();
                    int radius = (int)(CapProvider.this.miningEnhancement.applyPropertyModifiers("aoeMiningDiameter") - 1.0) / 2;
                    switch (side) {
                        case UP: 
                        case DOWN: {
                            posList = BlockPos.func_218281_b((BlockPos)pos.func_177964_d(radius).func_177985_f(radius), (BlockPos)pos.func_177970_e(radius).func_177965_g(radius));
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            posList = BlockPos.func_218281_b((BlockPos)pos.func_177981_b(radius).func_177964_d(radius), (BlockPos)pos.func_177979_c(radius).func_177970_e(radius));
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            posList = BlockPos.func_218281_b((BlockPos)pos.func_177981_b(radius).func_177985_f(radius), (BlockPos)pos.func_177979_c(radius).func_177965_g(radius));
                            break;
                        }
                        default: {
                            posList = new ArrayList().stream();
                        }
                    }
                    posList.forEach(blockPos -> retList.add((Object)blockPos.func_185334_h()));
                }
                return retList;
            }
        }

        class Enhancement
        extends MiningEnhancement {
            public Enhancement(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockStartBreak(ItemStack itemStack, BlockPos posIn, PlayerEntity player) {
                if (player.field_70170_p.field_72995_K) {
                    return false;
                }
                AtomicBoolean harvested = new AtomicBoolean(false);
                BlockRayTraceResult rayTraceResult = TunnelBoreModule.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
                if (rayTraceResult == null || rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                    return false;
                }
                int radius = (int)(this.applyPropertyModifiers("aoeMiningDiameter") - 1.0) / 2;
                if (radius == 0) {
                    return false;
                }
                NonNullList<BlockPos> posList = CapProvider.this.highlight.getBlockPositions(rayTraceResult);
                int energyUsage = this.getEnergyUsage();
                AtomicInteger blocksBroken = new AtomicInteger(0);
                itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(modeChanging -> posList.forEach(blockPos -> {
                    BlockState state = player.field_70170_p.func_180495_p(blockPos);
                    for (ItemStack blockBreakingModule : modeChanging.getInstalledModulesOfType(IBlockBreakingModule.class)) {
                        int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                        if (!blockBreakingModule.getCapability(PowerModuleCapability.POWER_MODULE).filter(IBlockBreakingModule.class::isInstance).map(IBlockBreakingModule.class::cast).map(b -> {
                            if (b.canHarvestBlock(itemStack, state, player, blockPos, playerEnergy - energyUsage)) {
                                Block.func_196263_a((BlockState)state, (BlockState)Blocks.field_150350_a.func_176223_P(), (IWorld)player.field_70170_p, (BlockPos)blockPos, (int)3);
                                ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)(b.getEnergyUsage() + energyUsage));
                                return true;
                            }
                            return false;
                        }).orElse(false).booleanValue()) continue;
                        if (posIn == blockPos) {
                            harvested.set(true);
                        }
                        blocksBroken.getAndAdd(1);
                        break;
                    }
                }));
                return harvested.get();
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("aoeEnergy");
            }
        }
    }
}

