/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.movement;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.config.NuminaSettings;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.util.client.control.PlayerMovementInputWrapper;
import lehjr.numina.util.client.sound.Musique;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.client.sound.MPSSoundDictionary;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.event.MovementManager;
import lehjr.powersuits.item.module.AbstractPowerModule;
import lehjr.powersuits.item.module.movement.SprintAssistModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class SwimAssistModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.MOVEMENT, ModuleTarget.LEGSONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addTradeoffProperty("thrust", "swimEnergy", 1000.0, "FE");
                    this.addTradeoffProperty("thrust", "underwaterMovBoost", 1.0, "m/s");
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack itemStack) {
                PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
                if (player.func_70090_H() && !player.func_184218_aH() && (playerInput.strafeKey != 0 || playerInput.forwardKey || playerInput.jumpKey || player.func_213453_ef())) {
                    int playerEnergy;
                    double moveRatio = 0.0;
                    if (playerInput.forwardKey) {
                        moveRatio += 1.0;
                    }
                    if (playerInput.strafeKey != 0) {
                        moveRatio += 1.0;
                    }
                    if (playerInput.jumpKey || player.func_213453_ef()) {
                        moveRatio += 0.04000000000000001;
                    }
                    double swimAssistRate = this.applyPropertyModifiers("underwaterMovBoost") * 0.05 * moveRatio;
                    double swimEnergyConsumption = this.applyPropertyModifiers("swimEnergy");
                    if (swimEnergyConsumption < (double)(playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player))) {
                        if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                            Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (Float)Float.valueOf(1.0f), (Boolean)true);
                        } else if (player.field_70170_p.func_82737_E() % 5L == 0L) {
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)swimEnergyConsumption * 5));
                        }
                        MovementManager.thrust(player, swimAssistRate, true);
                    } else {
                        this.onPlayerTickInactive(player, itemStack);
                    }
                } else {
                    this.onPlayerTickInactive(player, itemStack);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, @Nonnull ItemStack itemStack) {
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST);
                }
                SprintAssistModule.setMovementModifier(this.getModuleStack(), 0.0, (Attribute)ForgeMod.SWIM_SPEED.get(), ((Attribute)ForgeMod.SWIM_SPEED.get()).func_233754_c_());
            }
        }
    }
}

