/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.item.module.vision;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.powersuits.config.MPSSettings;
import lehjr.powersuits.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class NightVisionModule
extends AbstractPowerModule {
    static final int powerDrain = 50;
    private static final Effect nightvision = Effects.field_76439_r;

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.VISION, ModuleTarget.HEADONLY, MPSSettings::getModuleConfig);
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack item) {
                EffectInstance nightVisionEffect;
                if (player.field_70170_p.field_72995_K) {
                    return;
                }
                double totalEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                EffectInstance effectInstance = nightVisionEffect = player.func_70644_a(nightvision) ? player.func_70660_b(nightvision) : null;
                if (totalEnergy > 50.0) {
                    if (nightVisionEffect == null || nightVisionEffect.func_76459_b() < 250 && nightVisionEffect.func_76458_c() == -3) {
                        player.func_195064_c(new EffectInstance(nightvision, 500, -3, false, false));
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)50);
                    }
                } else {
                    this.onPlayerTickInactive(player, item);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack item) {
                EffectInstance nightVisionEffect = null;
                if (player.func_70644_a(nightvision) && (nightVisionEffect = player.func_70660_b(nightvision)).func_76458_c() == -3) {
                    player.func_195063_d(nightvision);
                }
            }
        }
    }
}

