/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.network.packets;

import java.util.function.Supplier;
import lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ColourInfoPacket {
    protected EquipmentSlotType slotType;
    protected int[] tagData;

    public ColourInfoPacket() {
    }

    public ColourInfoPacket(EquipmentSlotType slotType, int[] tagData) {
        this.slotType = slotType;
        this.tagData = tagData;
    }

    public static void write(ColourInfoPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179249_a((Enum)msg.slotType);
        packetBuffer.func_186875_a(msg.tagData);
    }

    public static ColourInfoPacket read(PacketBuffer packetBuffer) {
        return new ColourInfoPacket((EquipmentSlotType)packetBuffer.func_179257_a(EquipmentSlotType.class), packetBuffer.func_186863_b());
    }

    public static void handle(ColourInfoPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            EquipmentSlotType slotType = message.slotType;
            int[] tagData = message.tagData;
            player.func_184582_a(slotType).getCapability(ModelSpecNBTCapability.RENDER).ifPresent(render -> render.setColorArray(tagData));
        });
        ctx.get().setPacketHandled(true);
    }
}

