/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.network.packets;

import java.util.function.Supplier;
import lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class CreativeInstallPacket {
    protected EquipmentSlotType slotType;
    protected ResourceLocation regName;

    public CreativeInstallPacket() {
    }

    public CreativeInstallPacket(EquipmentSlotType slotType, ResourceLocation regName) {
        this.slotType = slotType;
        this.regName = regName;
    }

    public static void write(CreativeInstallPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_179249_a((Enum)msg.slotType);
        packetBuffer.func_192572_a(msg.regName);
    }

    public static CreativeInstallPacket read(PacketBuffer packetBuffer) {
        return new CreativeInstallPacket((EquipmentSlotType)packetBuffer.func_179257_a(EquipmentSlotType.class), packetBuffer.func_192575_l());
    }

    public static void handle(CreativeInstallPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            EquipmentSlotType slotType = message.slotType;
            ResourceLocation regName = message.regName;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(regName);
            ItemStack module = new ItemStack((IItemProvider)item, 1);
            module.getCapability(CapabilityEnergy.ENERGY).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(iEnergyStorage.getMaxEnergyStored(), false));
            player.func_184582_a(slotType).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModularItem.class::isInstance).map(IModularItem.class::cast).ifPresent(iModularItem -> {
                if (!iModularItem.getInstalledModuleNames().contains(regName)) {
                    for (int index = 0; index < iModularItem.getSlots() && !iModularItem.insertItem(index, module, false).func_77969_a(ItemStack.field_190927_a); ++index) {
                    }
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

