/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.SpeakerInstance;
import dan200.computercraft.client.sound.SpeakerSound;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.audio.IAudioStream;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class SpeakerManager {
    private static final Map<UUID, SpeakerInstance> sounds = new ConcurrentHashMap<UUID, SpeakerInstance>();

    @SubscribeEvent
    public static void playStreaming(PlayStreamingSourceEvent event) {
        if (!(event.getSound() instanceof SpeakerSound)) {
            return;
        }
        SpeakerSound sound = (SpeakerSound)event.getSound();
        if (sound.stream == null) {
            return;
        }
        event.getSource().func_216433_a((IAudioStream)sound.stream);
        event.getSource().func_216438_c();
        sound.field_184368_b = event.getSource();
        sound.executor = event.getManager().field_217940_j;
    }

    public static SpeakerInstance getSound(UUID source) {
        return sounds.computeIfAbsent(source, x -> new SpeakerInstance());
    }

    public static void stopSound(UUID source) {
        SpeakerInstance sound = sounds.remove(source);
        if (sound != null) {
            sound.stop();
        }
    }

    public static void moveSound(UUID source, Vector3d position) {
        SpeakerInstance sound = sounds.get(source);
        if (sound != null) {
            sound.setPosition(position);
        }
    }

    public static void reset() {
        sounds.clear();
    }
}

