/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.request;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.core.apis.handles.ArrayByteChannel;
import dan200.computercraft.core.apis.handles.BinaryReadableHandle;
import dan200.computercraft.core.apis.handles.EncodedReadableHandle;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import dan200.computercraft.core.apis.http.HTTPRequestException;
import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.core.apis.http.options.Options;
import dan200.computercraft.core.apis.http.request.HttpRequest;
import dan200.computercraft.core.apis.http.request.HttpResponseHandle;
import dan200.computercraft.core.tracking.TrackingField;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class HttpRequestHandler
extends SimpleChannelInboundHandler<HttpObject>
implements Closeable {
    private static final int DEFAULT_MAX_COMPOSITE_BUFFER_COMPONENTS = 1024;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final HttpRequest request;
    private boolean closed = false;
    private final URI uri;
    private final HttpMethod method;
    private final Options options;
    private Charset responseCharset;
    private final HttpHeaders responseHeaders = new DefaultHttpHeaders();
    private HttpResponseStatus responseStatus;
    private CompositeByteBuf responseBody;

    HttpRequestHandler(HttpRequest request, URI uri, HttpMethod method, Options options) {
        this.request = request;
        this.uri = uri;
        this.method = method;
        this.options = options;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.request.checkClosed()) {
            return;
        }
        ByteBuf body = this.request.body();
        body.resetReaderIndex().retain();
        String requestUri = this.uri.getRawPath();
        if (this.uri.getRawQuery() != null) {
            requestUri = requestUri + "?" + this.uri.getRawQuery();
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, requestUri, body);
        request.setMethod(this.method);
        request.headers().set(this.request.headers());
        if (!request.headers().contains((CharSequence)HttpHeaderNames.ACCEPT_CHARSET)) {
            request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_CHARSET, (Object)"UTF-8");
        }
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(this.uri.getPort() < 0 ? this.uri.getHost() : this.uri.getHost() + ":" + this.uri.getPort()));
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.channel().writeAndFlush((Object)request);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.closed) {
            this.request.failure("Could not connect");
        }
        super.channelInactive(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject message) {
        if (this.closed || this.request.checkClosed()) {
            return;
        }
        if (message instanceof HttpResponse) {
            URI redirect;
            HttpResponse response = (HttpResponse)message;
            if (this.request.redirects.get() > 0 && (redirect = this.getRedirect(response.status(), response.headers())) != null && !this.uri.equals(redirect) && this.request.redirects.getAndDecrement() > 0) {
                this.closed = true;
                ctx.close();
                try {
                    HttpRequest.checkUri(redirect);
                }
                catch (HTTPRequestException e) {
                    this.request.failure(e.getMessage());
                    return;
                }
                this.request.request(redirect, response.status().code() == 303 ? HttpMethod.GET : this.method);
                return;
            }
            this.responseCharset = HttpUtil.getCharset((HttpMessage)response, (Charset)StandardCharsets.UTF_8);
            this.responseStatus = response.status();
            this.responseHeaders.add(response.headers());
        }
        if (message instanceof HttpContent) {
            ByteBuf partial;
            HttpContent content = (HttpContent)message;
            if (this.responseBody == null) {
                this.responseBody = ctx.alloc().compositeBuffer(1024);
            }
            if ((partial = content.content()).isReadable()) {
                if (this.options.maxDownload != 0L && (long)(this.responseBody.readableBytes() + partial.readableBytes()) > this.options.maxDownload) {
                    this.closed = true;
                    ctx.close();
                    this.request.failure("Response is too large");
                    return;
                }
                this.responseBody.addComponent(true, partial.retain());
            }
            if (message instanceof LastHttpContent) {
                LastHttpContent last = (LastHttpContent)message;
                this.responseHeaders.add(last.trailingHeaders());
                if (this.responseHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                    this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.responseBody.readableBytes());
                }
                ctx.close();
                this.sendResponse();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ComputerCraft.logComputerErrors) {
            ComputerCraft.log.error("Error handling HTTP response", cause);
        }
        this.request.failure(NetworkUtils.toFriendlyError(cause));
    }

    private void sendResponse() {
        CompositeByteBuf body = this.responseBody;
        byte[] bytes = body == null ? EMPTY_BYTES : NetworkUtils.toBytes((ByteBuf)body);
        HttpResponseStatus status = this.responseStatus;
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry header : this.responseHeaders) {
            String existing = (String)headers.get(header.getKey());
            headers.put((String)header.getKey(), existing == null ? (String)header.getValue() : existing + "," + (String)header.getValue());
        }
        this.request.environment().addTrackingChange(TrackingField.HTTP_DOWNLOAD, HttpRequest.getHeaderSize(this.responseHeaders) + (long)bytes.length);
        ArrayByteChannel contents = new ArrayByteChannel(bytes);
        HandleGeneric reader = this.request.isBinary() ? BinaryReadableHandle.of(contents) : new EncodedReadableHandle(EncodedReadableHandle.open(contents, this.responseCharset));
        HttpResponseHandle stream = new HttpResponseHandle(reader, status.code(), status.reasonPhrase(), headers);
        if (status.code() >= 200 && status.code() < 400) {
            this.request.success(stream);
        } else {
            this.request.failure(status.reasonPhrase(), stream);
        }
    }

    private URI getRedirect(HttpResponseStatus status, HttpHeaders headers) {
        int code = status.code();
        if (code < 300 || code > 307 || code == 304 || code == 306) {
            return null;
        }
        String location = headers.get((CharSequence)HttpHeaderNames.LOCATION);
        if (location == null) {
            return null;
        }
        try {
            return this.uri.resolve(new URI(location));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return null;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.responseBody != null) {
            this.responseBody.release();
            this.responseBody = null;
        }
    }
}

