/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.network.NetworkMessage;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PlayRecordClientMessage
implements NetworkMessage {
    private final BlockPos pos;
    private final String name;
    private final SoundEvent soundEvent;

    public PlayRecordClientMessage(BlockPos pos, SoundEvent event, String name) {
        this.pos = pos;
        this.name = name;
        this.soundEvent = event;
    }

    public PlayRecordClientMessage(BlockPos pos) {
        this.pos = pos;
        this.name = null;
        this.soundEvent = null;
    }

    public PlayRecordClientMessage(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        if (buf.readBoolean()) {
            this.name = buf.func_150789_c(Short.MAX_VALUE);
            this.soundEvent = (SoundEvent)buf.readRegistryIdSafe(SoundEvent.class);
        } else {
            this.name = null;
            this.soundEvent = null;
        }
    }

    @Override
    public void toBytes(@Nonnull PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        if (this.soundEvent == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_180714_a(this.name);
            buf.writeRegistryId((IForgeRegistryEntry)this.soundEvent);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71438_f.playRecord(this.soundEvent, this.pos, null);
        if (this.name != null) {
            mc.field_71456_v.func_238451_a_((ITextComponent)new StringTextComponent(this.name));
        }
    }
}

