/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.ai.pathing;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockClassChecker {
    public static final Logger LOGGER = LogManager.getLogger((String)"RoadRunner Block AI Pathing analysis");
    private static final Map<Class<?>, Boolean> DYNAMIC_TYPE_CACHE = new ConcurrentHashMap();
    private static final Function<Class<?>, Boolean> DYNAMIC_TYPE_CHECKER = BlockClassChecker.hasNonstandardImplementation("getAiPathNodeType", BlockState.class, IBlockReader.class, BlockPos.class, MobEntity.class);
    private static final Map<Class<?>, Boolean> DYNAMIC_FIRE_CACHE = new ConcurrentHashMap();
    private static final Function<Class<?>, Boolean> DYNAMIC_FIRE_CHECKER = BlockClassChecker.hasNonstandardImplementation("isBurning", BlockState.class, IBlockReader.class, BlockPos.class);

    public static boolean shouldUseDynamicTypeCheck(Class<?> blockClass) {
        return DYNAMIC_TYPE_CACHE.computeIfAbsent(blockClass, DYNAMIC_TYPE_CHECKER);
    }

    public static boolean shouldUseDynamicBurningCheck(Class<?> blockClass) {
        return DYNAMIC_FIRE_CACHE.computeIfAbsent(blockClass, DYNAMIC_FIRE_CHECKER);
    }

    private static Function<Class<?>, Boolean> hasNonstandardImplementation(String name, Class<?> ... args) {
        return blockClass -> {
            try {
                Method dynamicGetType = blockClass.getMethod(name, args);
                return dynamicGetType.getDeclaringClass() != IForgeBlock.class;
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                String erroredClass = blockClass.getName();
                LOGGER.debug("Block Class {} could not be analysed: {}", (Object)erroredClass, (Object)e.getMessage());
                LOGGER.debug("Assuming the worst outcome, we're not going to override any behaviour here!");
                return true;
            }
            catch (Throwable e) {
                String erroredClass = blockClass.getName();
                LOGGER.debug("Block Class {} could not be analysed because of a {}! Assuming the worst outcome, we're not going to override any behaviour here.", (Object)erroredClass, (Object)e.toString());
                return true;
            }
        };
    }
}

