/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityClassGroup {
    public static final EntityClassGroup BOAT_SHULKER_LIKE_COLLISION;
    public static final EntityClassGroup MINECART_BOAT_LIKE_COLLISION;
    public static final Logger LOGGER;
    private final Predicate<Class<?>> classFitEvaluator;
    private volatile Reference2ByteOpenHashMap<Class<?>> class2GroupContains = new Reference2ByteOpenHashMap();

    public EntityClassGroup(Predicate<Class<?>> classFitEvaluator) {
        Objects.requireNonNull(classFitEvaluator);
        this.classFitEvaluator = classFitEvaluator;
    }

    public void clear() {
        this.class2GroupContains = new Reference2ByteOpenHashMap();
    }

    public boolean contains(Class<?> entityClass) {
        byte contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
        if (contains != 2) {
            return contains == 1;
        }
        return this.testAndAddClass(entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAndAddClass(Class<?> entityClass) {
        byte contains;
        EntityClassGroup entityClassGroup = this;
        synchronized (entityClassGroup) {
            contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
            if (contains != 2) {
                return contains == 1;
            }
            Reference2ByteOpenHashMap newMap = this.class2GroupContains.clone();
            contains = this.classFitEvaluator.test(entityClass) ? (byte)1 : 0;
            newMap.put(entityClass, contains);
            this.class2GroupContains = newMap;
        }
        return contains == 1;
    }

    public static boolean isMethodFromSuperclassOverwritten(Class<?> clazz, Class<?> superclass, String methodName, Class<?> ... methodArgs) {
        if (clazz != null && clazz != superclass && superclass.isAssignableFrom(clazz)) {
            try {
                Method m = clazz.getMethod(methodName, methodArgs);
                return m.getDeclaringClass() != superclass;
            }
            catch (Throwable e) {
                String erroredClass = clazz.getName();
                LOGGER.warn("Entity Class {} could not be analysed because of a {}! Assuming the worst outcome, we're not going to override any behaviour here.", (Object)erroredClass, (Object)e.toString());
                LOGGER.warn("(If the class above belongs to a mod, they probably forgot to annotate their client-only code).");
                return true;
            }
        }
        return false;
    }

    static {
        LOGGER = LogManager.getLogger((String)"RoadRunner EntityClassGroup");
        String remapped_method_30948 = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_241845_aY", (Class[])new Class[0]).getName();
        BOAT_SHULKER_LIKE_COLLISION = new EntityClassGroup(entityClass -> EntityClassGroup.isMethodFromSuperclassOverwritten(entityClass, Entity.class, remapped_method_30948, new Class[0]));
        String remapped_method_30949 = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_241849_j", (Class[])new Class[]{Entity.class}).getName();
        MINECART_BOAT_LIKE_COLLISION = new EntityClassGroup(entityClass -> EntityClassGroup.isMethodFromSuperclassOverwritten(entityClass, Entity.class, remapped_method_30949, Entity.class));
        if (!MINECART_BOAT_LIKE_COLLISION.contains(MinecartEntity.class)) {
            throw new AssertionError();
        }
        if (!BOAT_SHULKER_LIKE_COLLISION.contains(ShulkerEntity.class)) {
            throw new AssertionError();
        }
        if (MINECART_BOAT_LIKE_COLLISION.contains(ShulkerEntity.class)) {
            LOGGER.warn("Either chunk.entity_class_groups is broken or something else gave Shulkers the minecart-like collision behavior.");
        }
        BOAT_SHULKER_LIKE_COLLISION.clear();
        MINECART_BOAT_LIKE_COLLISION.clear();
    }
}

