/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.explosions;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin {
    @Shadow
    @Final
    private float field_77280_f;
    @Shadow
    @Final
    private double field_77284_b;
    @Shadow
    @Final
    private double field_77285_c;
    @Shadow
    @Final
    private double field_77282_d;
    @Shadow
    @Final
    private World field_77287_j;
    @Shadow
    @Final
    private ExplosionContext field_234893_k_;
    @Shadow
    @Final
    private boolean field_77286_a;
    private final BlockPos.Mutable cachedPos = new BlockPos.Mutable();
    private int prevChunkX = Integer.MIN_VALUE;
    private int prevChunkZ = Integer.MIN_VALUE;
    private IChunk prevChunk;
    private boolean explodeAirBlocks;

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/damage/DamageSource;Lnet/minecraft/world/explosion/ExplosionBehavior;DDDFZLnet/minecraft/world/explosion/Explosion$DestructionType;)V"}, at={@At(value="TAIL")})
    private void init(World world, Entity entity, DamageSource damageSource, ExplosionContext explosionBehavior, double d, double e, double f, float g, boolean bl, Explosion.Mode destructionType, CallbackInfo ci) {
        boolean explodeAir = this.field_77286_a;
        if (!explodeAir && this.field_77287_j != null && this.field_77287_j.func_230315_m_().func_236046_h_()) {
            float overestimatedExplosionRange = 8 + (int)(6.0f * this.field_77280_f);
            boolean endPortalX = false;
            boolean endPortalZ = false;
            if ((double)overestimatedExplosionRange > Math.abs(this.field_77284_b - (double)endPortalX) && (double)overestimatedExplosionRange > Math.abs(this.field_77282_d - (double)endPortalZ)) {
                explodeAir = true;
            }
        }
        this.explodeAirBlocks = explodeAir;
    }

    @Redirect(method={"collectBlocksAndDamageEntities"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Sets;newHashSet()Ljava/util/HashSet;", remap=false))
    public HashSet<BlockPos> skipNewHashSet() {
        return null;
    }

    @ModifyConstant(method={"collectBlocksAndDamageEntities"}, constant={@Constant(intValue=16, ordinal=1)})
    public int skipLoop(int prevValue) {
        return 0;
    }

    @Redirect(method={"collectBlocksAndDamageEntities"}, at=@At(value="INVOKE", target="Ljava/util/List;addAll(Ljava/util/Collection;)Z"))
    public boolean collectBlocks(List<BlockPos> affectedBlocks, Collection<BlockPos> collection) {
        LongOpenHashSet touched = new LongOpenHashSet(0);
        Random random = this.field_77287_j.field_73012_v;
        for (int rayX = 0; rayX < 16; ++rayX) {
            boolean xPlane = rayX == 0 || rayX == 15;
            double vecX = (float)rayX / 15.0f * 2.0f - 1.0f;
            for (int rayY = 0; rayY < 16; ++rayY) {
                boolean yPlane = rayY == 0 || rayY == 15;
                double vecY = (float)rayY / 15.0f * 2.0f - 1.0f;
                for (int rayZ = 0; rayZ < 16; ++rayZ) {
                    boolean zPlane;
                    boolean bl = zPlane = rayZ == 0 || rayZ == 15;
                    if (!xPlane && !yPlane && !zPlane) continue;
                    double vecZ = (float)rayZ / 15.0f * 2.0f - 1.0f;
                    this.performRayCast(random, vecX, vecY, vecZ, touched);
                }
            }
        }
        LongIterator it = touched.iterator();
        boolean added = false;
        while (it.hasNext()) {
            added |= affectedBlocks.add(BlockPos.func_218283_e((long)it.nextLong()));
        }
        return added;
    }

    private void performRayCast(Random random, double vecX, double vecY, double vecZ, LongOpenHashSet touched) {
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        double normX = vecX / dist * 0.3;
        double normY = vecY / dist * 0.3;
        double normZ = vecZ / dist * 0.3;
        float strength = this.field_77280_f * (0.7f + random.nextFloat() * 0.6f);
        double stepX = this.field_77284_b;
        double stepY = this.field_77285_c;
        double stepZ = this.field_77282_d;
        int prevX = Integer.MIN_VALUE;
        int prevY = Integer.MIN_VALUE;
        int prevZ = Integer.MIN_VALUE;
        float prevResistance = 0.0f;
        while (strength > 0.0f) {
            float resistance;
            int blockX = MathHelper.func_76128_c((double)stepX);
            int blockY = MathHelper.func_76128_c((double)stepY);
            int blockZ = MathHelper.func_76128_c((double)stepZ);
            if (prevX != blockX || prevY != blockY || prevZ != blockZ) {
                resistance = this.traverseBlock(strength, blockX, blockY, blockZ, touched);
                prevX = blockX;
                prevY = blockY;
                prevZ = blockZ;
                prevResistance = resistance;
            } else {
                resistance = prevResistance;
            }
            strength -= resistance;
            strength -= 0.22500001f;
            stepX += normX;
            stepY += normY;
            stepZ += normZ;
        }
    }

    private float traverseBlock(float strength, int blockX, int blockY, int blockZ, LongOpenHashSet touched) {
        float reducedStrength;
        Optional blastResistance;
        ChunkSection section;
        BlockPos.Mutable pos = this.cachedPos.func_181079_c(blockX, blockY, blockZ);
        if (World.func_217405_b((int)blockY)) {
            Optional blastResistance2 = this.field_234893_k_.func_230312_a_((Explosion)this, (IBlockReader)this.field_77287_j, (BlockPos)pos, Blocks.field_150350_a.func_176223_P(), Fluids.field_204541_a.func_207188_f());
            if (blastResistance2.isPresent()) {
                return (((Float)blastResistance2.get()).floatValue() + 0.3f) * 0.3f;
            }
            return 0.0f;
        }
        int chunkX = blockX >> 4;
        int chunkZ = blockZ >> 4;
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            this.prevChunk = this.field_77287_j.func_212866_a_(chunkX, chunkZ);
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
        IChunk chunk = this.prevChunk;
        BlockState blockState = Blocks.field_150350_a.func_176223_P();
        float totalResistance = 0.0f;
        if (chunk != null && (section = chunk.func_76587_i()[blockY >> 4]) != null && !section.func_76663_a() && (blockState = section.func_177485_a(blockX & 0xF, blockY & 0xF, blockZ & 0xF)).func_177230_c() != Blocks.field_150350_a) {
            FluidState fluidState = blockState.func_204520_s();
            blastResistance = this.field_234893_k_.func_230312_a_((Explosion)this, (IBlockReader)this.field_77287_j, (BlockPos)pos, blockState, fluidState);
        } else {
            blastResistance = this.field_234893_k_.func_230312_a_((Explosion)this, (IBlockReader)this.field_77287_j, (BlockPos)pos, Blocks.field_150350_a.func_176223_P(), Fluids.field_204541_a.func_207188_f());
        }
        if (blastResistance.isPresent()) {
            totalResistance = (((Float)blastResistance.get()).floatValue() + 0.3f) * 0.3f;
        }
        if ((reducedStrength = strength - totalResistance) > 0.0f && (this.explodeAirBlocks || !blockState.func_196958_f()) && this.field_234893_k_.func_230311_a_((Explosion)this, (IBlockReader)this.field_77287_j, (BlockPos)pos, blockState, reducedStrength)) {
            touched.add(pos.func_218275_a());
        }
        return totalResistance;
    }
}

