/*
 * Decompiled with CFR 0.152.
 */
package shadows.fastsuite;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import shadows.fastsuite.FastSuite;

public class AuxRecipeManager
extends RecipeManager {
    public boolean active = false;
    private final Map<IRecipeType<?>, LinkedRecipeList<?>> linkedRecipes = new HashMap();

    protected void func_212853_a_(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.active = false;
        super.func_212853_a_(objectIn, resourceManagerIn, profilerIn);
    }

    public void processInitialRecipes(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes) {
        this.linkedRecipes.clear();
        long recipeCount = 0L;
        for (Map.Entry<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> e : recipes.entrySet()) {
            LinkedRecipeList list = new LinkedRecipeList(e.getValue().values());
            this.linkedRecipes.put(e.getKey(), list);
            recipeCount += (long)e.getValue().size();
        }
        FastSuite.LOG.info("Successfully processed {} recipes into the AuxRecipeManager.", (Object)recipeCount);
        this.active = true;
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> func_215371_a(IRecipeType<T> type, C inv, World world) {
        if (!this.active) {
            return super.func_215371_a(type, inv, world);
        }
        LinkedRecipeList<C> list = this.getRecipes(type);
        IRecipe<C> recipe = list.findFirstMatch(inv, world);
        return Optional.ofNullable(recipe);
    }

    private <C extends IInventory, T extends IRecipe<C>> LinkedRecipeList<C> getRecipes(IRecipeType<T> type) {
        return this.linkedRecipes.getOrDefault(type, LinkedRecipeList.EMPTY);
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> func_215369_c(IRecipeType<T> type, C inv, World world) {
        if (!this.active) {
            return super.func_215369_c(type, inv, world);
        }
        LinkedRecipeList<C> list = this.getRecipes(type);
        IRecipe<C> recipe = list.findFirstMatch(inv, world);
        if (recipe != null) {
            return recipe.func_179532_b(inv);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)inv.func_70301_a(i));
        }
        return nonnulllist;
    }

    public void func_223389_a(Iterable<IRecipe<?>> recipes) {
        super.func_223389_a(recipes);
        this.processInitialRecipes(this.field_199522_d);
    }

    public void dump() {
        for (Map.Entry<IRecipeType<?>, LinkedRecipeList<?>> e : this.linkedRecipes.entrySet()) {
            FastSuite.LOG.info("Recipes for type {}:", (Object)e.getKey().toString());
            LinkedRecipeList<?> list = e.getValue();
            RecipeNode temp = list.head;
            while (temp != null) {
                FastSuite.LOG.info("{}", (Object)temp.r.func_199560_c());
                temp = temp.next;
            }
        }
    }

    public static class RecipeNode<I extends IInventory> {
        final IRecipe<I> r;
        RecipeNode<I> next;
        RecipeNode<I> prev;

        public RecipeNode(IRecipe<I> r) {
            this.r = r;
        }

        public String toString() {
            return String.format("RecipeNode(%s)", this.r.func_199560_c());
        }

        boolean matches(I inv, World world) {
            return this.r.func_77569_a(inv, world);
        }
    }

    public static class LinkedRecipeList<I extends IInventory> {
        public static final LinkedRecipeList<IInventory> EMPTY = new LinkedRecipeList(Collections.emptyList());
        RecipeNode<I> head;
        RecipeNode<I> tail;

        public LinkedRecipeList(Collection<IRecipe<I>> recipes) {
            for (IRecipe<I> r : recipes) {
                if (r == null) continue;
                this.add(new RecipeNode<I>(r));
            }
        }

        void add(RecipeNode<I> node) {
            if (this.head == null) {
                this.head = node;
                this.tail = this.head;
            } else {
                this.tail.next = node;
                node.prev = this.tail;
                this.tail = node;
            }
        }

        void addToHead(RecipeNode<I> node) {
            if (this.head == null) {
                this.head = node;
                this.tail = this.head;
            } else {
                node.next = this.head;
                this.head.prev = node;
                this.head = node;
            }
        }

        void remove(RecipeNode<I> node) {
            if (node == this.head && node == this.tail) {
                this.tail = null;
                this.head = null;
            } else if (node == this.head) {
                this.head = this.head.next;
                if (this.head != null) {
                    this.head.prev = null;
                }
            } else if (node == this.tail) {
                this.tail = this.tail.prev;
                if (this.tail != null) {
                    this.tail.next = null;
                }
            } else {
                node.prev.next = node.next;
                node.next.prev = node.prev;
            }
            node.prev = null;
            node.next = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IRecipe<I> findFirstMatch(I inv, World world) {
            LinkedRecipeList linkedRecipeList = this;
            synchronized (linkedRecipeList) {
                RecipeNode<I> temp = this.head;
                int idx = 0;
                while (temp != null) {
                    if (temp.matches(inv, world)) {
                        if (idx > FastSuite.cacheSize) {
                            this.remove(temp);
                            this.addToHead(temp);
                        }
                        return temp.r;
                    }
                    temp = temp.next;
                    ++idx;
                }
                return null;
            }
        }
    }
}

