/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimals.client;

import com.google.common.collect.Maps;
import dev.itsmeow.betteranimals.client.BetterAnimalsConfig;
import dev.itsmeow.betteranimals.client.model.ModelNewBear;
import dev.itsmeow.betteranimals.client.model.ModelNewBee;
import dev.itsmeow.betteranimals.client.model.ModelNewCat;
import dev.itsmeow.betteranimals.client.model.ModelNewChicken;
import dev.itsmeow.betteranimals.client.model.ModelNewCow;
import dev.itsmeow.betteranimals.client.model.ModelNewDolphin;
import dev.itsmeow.betteranimals.client.model.ModelNewFox;
import dev.itsmeow.betteranimals.client.model.ModelNewPig;
import dev.itsmeow.betteranimals.client.model.ModelNewSheep;
import dev.itsmeow.betteranimals.client.model.ModelNewSilverfish;
import dev.itsmeow.betteranimals.client.model.ModelNewSpider;
import dev.itsmeow.betteranimals.client.model.ModelNewSquid;
import dev.itsmeow.betteranimals.client.model.ModelNewWolf;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewCatCollar;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewDolphinItem;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewFoxItem;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewMooshroomMushroom;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewPigSaddle;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewSheepWool;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewSpiderEyes;
import dev.itsmeow.betteranimals.client.render.entity.layer.LayerNewWolfCollar;
import dev.itsmeow.betteranimals.compat.QuarkUtil;
import dev.itsmeow.betteranimals.imdlib.client.IMDLibClient;
import dev.itsmeow.betteranimals.imdlib.client.render.ImplRenderer;
import dev.itsmeow.betteranimals.imdlib.client.util.ModelReplacementHandler;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.ModList;

public class Replacements {
    public static final ModelReplacementHandler H = IMDLibClient.getReplacementHandler("betteranimals");

    public static void addReplaces() {
        ImplRenderer.RenderDef cow = r -> r.childScale(0.5f).tSingle("cow").mSingle(new ModelNewCow());
        ImplRenderer.RenderDef pig = r -> r.childScale(0.5f).layer(LayerNewPigSaddle::new).tSingle("pig").mSingle(new ModelNewPig());
        ImplRenderer.RenderDef chicken = r -> r.childScale(0.45f).handleRotation((e, p) -> {
            float f = e.field_70888_h + (e.field_70886_e - e.field_70888_h) * p;
            float f1 = e.field_70884_g + (e.field_70883_f - e.field_70884_g) * p;
            return (MathHelper.func_76126_a((float)f) + 1.0f) * f1;
        }).tSingle("chicken").mSingle(new ModelNewChicken());
        H.addAction(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", () -> () -> {
            boolean quarkLoaded = ModList.get().isLoaded("quark");
            if (!quarkLoaded || !((Boolean)BetterAnimalsConfig.enableQuarkOverrideCow.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "cow", () -> () -> H.lambdaReplace(EntityType.field_200796_j, 0.7f, cow));
            }
            if (!quarkLoaded || !((Boolean)BetterAnimalsConfig.enableQuarkOverridePig.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "pig", () -> () -> H.lambdaReplace(EntityType.field_200784_X, 0.7f, pig));
            }
            if (!quarkLoaded || !((Boolean)BetterAnimalsConfig.enableQuarkOverrideChicken.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "chicken", () -> () -> H.lambdaReplace(EntityType.field_200795_i, 0.4f, chicken));
            }
        });
        H.addAction(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "quark", () -> () -> {
            if (((Boolean)BetterAnimalsConfig.enableQuarkOverrideCow.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "cow", () -> () -> H.lambdaReplace(EntityType.field_200796_j, 0.7f, r -> cow.apply(r).tMappedRaw(e -> QuarkUtil.getTextureOrShiny((Entity)e, QuarkUtil.VariantTextureType.COW))));
            }
            if (((Boolean)BetterAnimalsConfig.enableQuarkOverridePig.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "pig", () -> () -> H.lambdaReplace(EntityType.field_200784_X, 0.7f, r -> pig.apply(r).tMappedRaw(e -> QuarkUtil.getTextureOrShiny((Entity)e, QuarkUtil.VariantTextureType.PIG))));
            }
            if (((Boolean)BetterAnimalsConfig.enableQuarkOverrideChicken.get()).booleanValue()) {
                H.addReplace(ModelReplacementHandler.RegistrationTime.CLIENTSETUP, "minecraft", "chicken", () -> () -> H.lambdaReplace(EntityType.field_200795_i, 0.4f, r -> chicken.apply(r).tMappedRaw(e -> QuarkUtil.getTextureOrShiny((Entity)e, QuarkUtil.VariantTextureType.CHICKEN))));
            }
        });
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "sheep", () -> () -> H.lambdaReplace(EntityType.field_200737_ac, 0.4f, r -> r.childScale(0.5f).layer(LayerNewSheepWool::new).tMapped(e -> e.func_70631_g_() ? "lamb" : "sheep").mSingle(new ModelNewSheep())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "wolf", () -> () -> H.lambdaReplace(EntityType.field_200724_aC, 0.25f, r -> r.preRender((e, s, p) -> {
            s.func_227862_a_(0.8f, 0.8f, 0.8f);
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
        }).handleRotation((e, p) -> e.func_70920_v()).layer(LayerNewWolfCollar::new).tMapped(e -> e.func_70909_n() ? "wolf/wolf_tame" : (e.func_233678_J__() ? "wolf/wolf_angry" : "wolf/wolf")).mSingle(new ModelNewWolf())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "mooshroom", () -> () -> H.lambdaReplace(EntityType.field_200780_T, 0.7f, r -> r.preRender((e, s, p) -> {
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.36f, 0.36f, 0.36f);
            }
        }).layer(LayerNewMooshroomMushroom::new).tCondition(e -> e.func_213444_dV() == MooshroomEntity.Type.RED, "mooshroom", "mooshroom_brown").mSingle(new ModelNewCow())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "squid", () -> () -> H.lambdaReplace(EntityType.field_200749_ao, 0.7f, r -> r.applyRotations((e, s, a, rot, p) -> {
            float f = e.field_70862_e + (e.field_70861_d - e.field_70862_e) * p;
            float f1 = e.field_70860_g + (e.field_70859_f - e.field_70860_g) * p;
            s.func_227861_a_(0.0, 0.5, 0.0);
            s.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rot));
            s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f));
            s.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f1));
            s.func_227861_a_(0.0, (double)-1.2f, 0.0);
        }).handleRotation((e, p) -> -(e.field_70865_by + (e.field_70866_j - e.field_70865_by) * p)).tSingle("squid").mSingle(new ModelNewSquid())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "spider", () -> () -> H.lambdaReplace(EntityType.field_200748_an, 1.0f, r -> r.preRender((e, s, p) -> {
            if (e.func_70841_p()) {
                s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                s.func_227861_a_(0.0, 0.75, -0.5);
            }
        }).layer(LayerNewSpiderEyes::new).tSingle("spider").mSingle(new ModelNewSpider())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "cavespider", () -> () -> H.lambdaReplace(EntityType.field_200794_h, 0.4f, r -> r.preRender((e, s, p) -> {
            if (e.func_70841_p()) {
                s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                s.func_227861_a_(0.0, 0.75, -0.5);
            }
            s.func_227862_a_(0.5f, 0.5f, 0.5f);
        }).layer(LayerNewSpiderEyes::new).tSingle("cave_spider").mSingle(new ModelNewSpider())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "silverfish", () -> () -> H.lambdaReplace(EntityType.field_200740_af, 0.25f, r -> r.preRender((e, s, p) -> s.func_227862_a_(0.5f, 0.5f, 0.5f)).tSingle("silverfish").mSingle(new ModelNewSilverfish())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "polarbear", () -> () -> H.lambdaReplace(EntityType.field_200786_Z, 0.7f, r -> r.childScale(0.7f).tSingle("polarbear").mSingle(new ModelNewBear())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "ocelot", () -> () -> H.lambdaReplace(EntityType.field_200781_U, 0.5f, r -> r.preRender((e, s, p) -> {
            s.func_227862_a_(0.8f, 0.8f, 0.8f);
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
        }).tSingle("cat/ocelot").mSingle(new ModelNewCat())));
        Map catTextures = (Map)Util.func_200696_a((Object)Maps.newHashMap(), map -> {
            map.put(0, "cat/tabby");
            map.put(1, "cat/black");
            map.put(2, "cat/red");
            map.put(3, "cat/siamese");
            map.put(4, "cat/british_shorthair");
            map.put(5, "cat/calico");
            map.put(6, "cat/persian");
            map.put(7, "cat/ragdoll");
            map.put(8, "cat/white");
            map.put(9, "cat/jellie");
            map.put(10, "cat/all_black");
        });
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "cat", () -> () -> H.lambdaReplace(EntityType.field_220360_g, 0.5f, r -> r.preRender((e, s, p) -> {
            s.func_227862_a_(0.8f, 0.8f, 0.8f);
            if (e.func_70909_n()) {
                s.func_227862_a_(0.9f, 0.9f, 0.9f);
            }
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
        }).layer(LayerNewCatCollar::new).tMapped(e -> (String)catTextures.get(e.func_213413_ef())).mSingle(new ModelNewCat())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "fox", () -> () -> H.lambdaReplace(EntityType.field_220356_B, 0.4f, r -> r.preRender((e, s, p) -> {
            if (e.func_70631_g_()) {
                s.func_227862_a_(0.5f, 0.5f, 0.5f);
            }
            if (e.func_70608_bn()) {
                s.func_227861_a_(0.0, 0.5, 0.0);
            }
            if (e.func_213455_dW()) {
                s.func_227861_a_(0.0, (double)0.2f, 0.0);
            }
        }).applyRotations((e, s, a, rot, p) -> {
            if (e.func_213480_dY() || e.func_213472_dX()) {
                s.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-MathHelper.func_219799_g((float)p, (float)e.field_70127_C, (float)e.field_70125_A)));
            }
        }, ImplRenderer.SuperCallApplyRotations.PRE).layer(LayerNewFoxItem::new).tMapped(e -> e.func_213471_dV() == FoxEntity.Type.RED ? (e.func_70608_bn() ? "fox/fox_sleep" : "fox/fox") : (e.func_70608_bn() ? "fox/snow_fox_sleep" : "fox/snow_fox")).mSingle(new ModelNewFox())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "bee", () -> () -> H.lambdaReplace(EntityType.field_226289_e_, 0.4f, r -> r.childScale(0.5f).tMapped(e -> e.func_233678_J__() ? (e.func_226411_eD_() ? "bee/bee_angry_nectar" : "bee/bee_angry") : (e.func_226411_eD_() ? "bee/bee_nectar" : "bee/bee")).mSingle(new ModelNewBee())));
        H.addReplace(ModelReplacementHandler.RegistrationTime.MODELREGISTRY, "minecraft", "dolphin", () -> () -> H.lambdaReplace(EntityType.field_205137_n, 0.7f, r -> r.layer(LayerNewDolphinItem::new).tSingle("dolphin").mSingle(new ModelNewDolphin())));
    }
}

