/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects.particles;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.particles.Collections;
import org.orecruncher.environs.effects.particles.SteamCloudParticle;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.particles.ParticleCollisionResult;
import org.orecruncher.sndctrl.api.acoustics.Library;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleHooks {
    private static final ResourceLocation STEAM_HISS_ACOUSTIC = new ResourceLocation("environs", "steam.hiss");
    private static final ResourceLocation WATER_DRIP_ACOUSTIC = new ResourceLocation("environs", "waterdrips");
    private static final ResourceLocation WATER_DROP_ACOUSTIC = new ResourceLocation("environs", "waterdrops");
    private static final double LIQUID_HEIGHT_ADJUST = 0.2111111111111111;

    private ParticleHooks() {
    }

    private static boolean doRipples() {
        return (Boolean)Config.CLIENT.effects.enableWaterRipples.get();
    }

    public static void dripHandler(@Nonnull DripParticle particle) {
        if (particle.field_187127_g < 1.0) {
            particle.func_187112_i();
            return;
        }
        ClientWorld world = GameUtils.getWorld();
        BlockPos pos = new BlockPos(particle.field_187126_f, particle.field_187127_g - 0.01, particle.field_187128_h);
        BlockState state = world.func_180495_p(pos);
        FluidState fluidState = world.func_204610_c(pos);
        if (!fluidState.func_206888_e()) {
            float fluidHeight = fluidState.func_215679_a((IBlockReader)world, pos);
            float actualHeight = fluidHeight + (float)pos.func_177956_o();
            if (fluidHeight < 1.0f && particle.field_187127_g <= (double)actualHeight) {
                ResourceLocation acoustic;
                boolean isDripLava = particle.field_204502_a.func_207185_a((ITag)FluidTags.field_206960_b);
                Vector3d vecPos = new Vector3d(particle.field_187126_f, particle.field_187127_g, particle.field_187128_h);
                if (fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                    if (isDripLava) {
                        acoustic = WATER_DROP_ACOUSTIC;
                    } else {
                        ParticleHooks.createSteamCloud((IBlockReader)world, vecPos);
                        acoustic = STEAM_HISS_ACOUSTIC;
                    }
                } else {
                    if (ParticleHooks.doRipples()) {
                        Collections.addWaterRipple((IBlockReader)world, particle.field_187126_f, particle.field_187127_g + 0.01, particle.field_187128_h);
                    }
                    if (isDripLava) {
                        ParticleHooks.createSteamCloud((IBlockReader)world, vecPos);
                        acoustic = STEAM_HISS_ACOUSTIC;
                    } else {
                        acoustic = WATER_DRIP_ACOUSTIC;
                    }
                }
                Library.resolve(acoustic).playAt(vecPos);
                particle.func_187112_i();
                return;
            }
        }
        if (particle.field_187132_l) {
            ResourceLocation acoustic;
            Vector3d vecPos = new Vector3d(particle.field_187126_f, particle.field_187127_g, particle.field_187128_h);
            if (ParticleHooks.doSteamHiss(particle.field_204502_a, state)) {
                ParticleHooks.createSteamCloud((IBlockReader)world, vecPos);
                acoustic = STEAM_HISS_ACOUSTIC;
                particle.func_187112_i();
                particle.field_187132_l = false;
            } else {
                acoustic = WATER_DROP_ACOUSTIC;
            }
            Library.resolve(acoustic).playAt(vecPos);
        }
    }

    public static void splashHandler(@Nonnull Fluid fluidType, @Nonnull ParticleCollisionResult collision, boolean playSound) {
        float actualHeight;
        IBlockReader world = collision.world;
        Vector3d particlePos = collision.position;
        BlockPos pos = new BlockPos(particlePos.field_72450_a, particlePos.field_72448_b - 0.01, particlePos.field_72449_c);
        BlockState state = collision.state;
        if (collision.onGround) {
            ResourceLocation acoustic;
            if (ParticleHooks.doSteamHiss(fluidType, state)) {
                ParticleHooks.createSteamCloud(world, particlePos);
                acoustic = STEAM_HISS_ACOUSTIC;
            } else {
                acoustic = WATER_DROP_ACOUSTIC;
            }
            if (playSound) {
                Library.resolve(acoustic).playAt(particlePos);
            }
            return;
        }
        FluidState fluidState = collision.fluidState;
        if (!fluidState.func_206888_e() && fluidState.func_206889_d() && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && particlePos.field_72448_b <= (double)(actualHeight = fluidState.func_215679_a(world, pos) + (float)pos.func_177956_o())) {
            ResourceLocation acoustic;
            boolean isDripLava = fluidType.func_207185_a((ITag)FluidTags.field_206960_b);
            if (fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                if (isDripLava) {
                    acoustic = WATER_DROP_ACOUSTIC;
                } else {
                    ParticleHooks.createSteamCloud(world, particlePos);
                    acoustic = STEAM_HISS_ACOUSTIC;
                }
            } else {
                if (ParticleHooks.doRipples()) {
                    Collections.addWaterRipple(world, particlePos.field_72450_a, (double)actualHeight + 0.2111111111111111, particlePos.field_72449_c);
                }
                if (isDripLava) {
                    ParticleHooks.createSteamCloud(world, particlePos);
                    acoustic = STEAM_HISS_ACOUSTIC;
                } else {
                    acoustic = WATER_DRIP_ACOUSTIC;
                }
            }
            if (playSound) {
                Library.resolve(acoustic).playAt(particlePos);
            }
        }
    }

    public static boolean spawnRippleOnBlock(@Nonnull World world, @Nonnull Vector3d position) {
        if (ParticleHooks.doRipples()) {
            BlockPos pos = new BlockPos(position.field_72450_a, position.field_72448_b - 0.01, position.field_72449_c);
            FluidState fluidState = world.func_204610_c(pos);
            if (fluidState.func_206888_e()) {
                return false;
            }
            float actualHeight = fluidState.func_215679_a((IBlockReader)world, pos) + (float)pos.func_177956_o();
            Collections.addWaterRipple((IBlockReader)world, position.field_72450_a, (double)actualHeight + 0.2111111111111111, position.field_72449_c);
            return true;
        }
        return false;
    }

    private static void createSteamCloud(@Nonnull IBlockReader world, @Nonnull Vector3d pos) {
        SteamCloudParticle steamCloud = new SteamCloudParticle((World)GameUtils.getWorld(), pos.field_72450_a, pos.field_72448_b + 0.01, pos.field_72449_c, 0.01);
        GameUtils.getMC().field_71452_i.func_78873_a((Particle)steamCloud);
    }

    private static boolean doSteamHiss(@Nonnull Fluid particleFluid, @Nonnull BlockState state) {
        return JetEffect.HOTBLOCK_PREDICATE.test(state) && particleFluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }
}

