/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.mobeffects.footsteps.accents;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.mobeffects.config.Config;
import org.orecruncher.mobeffects.footsteps.accents.IFootstepAccentProvider;
import org.orecruncher.mobeffects.library.ItemData;
import org.orecruncher.mobeffects.library.ItemLibrary;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;

@OnlyIn(value=Dist.CLIENT)
class ArmorAccents
implements IFootstepAccentProvider {
    ArmorAccents() {
    }

    @Nullable
    protected IAcoustic resolveArmor(@Nonnull ItemStack stack) {
        ItemData id = ItemLibrary.getItemData(stack);
        if (id.isArmor()) {
            return ((ItemData.ArmorItemData)id).getArmorSound(stack);
        }
        return null;
    }

    protected IAcoustic resolveFootArmor(@Nonnull ItemStack stack) {
        ItemData id = ItemLibrary.getItemData(stack);
        if (id.isArmor()) {
            return ((ItemData.ArmorItemData)id).getFootArmorSound(stack);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)Config.CLIENT.footsteps.enableArmorAccents.get();
    }

    @Override
    public void provide(@Nonnull LivingEntity entity, @Nonnull BlockPos blockPos, @Nonnull BlockState posState, @Nonnull ObjectArray<IAcoustic> acoustics) {
        ItemStack armor = ItemData.effectiveArmorItemStack(entity);
        ItemStack foot = ItemData.footArmorItemStack(entity);
        IAcoustic armorAddon = this.resolveArmor(armor);
        IAcoustic footAddon = this.resolveFootArmor(foot);
        if (armorAddon != null) {
            acoustics.add(armorAddon);
            if (armorAddon == footAddon) {
                footAddon = null;
            }
        }
        if (footAddon != null) {
            acoustics.add(footAddon);
        }
    }
}

