/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.sndctrl.gui.IndividualSoundControlListEntry;
import org.orecruncher.sndctrl.library.IndividualSoundConfig;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public class IndividualSoundControlList
extends AbstractOptionList<IndividualSoundControlListEntry> {
    private final Screen parent;
    private final boolean enablePlay;
    private final int width;
    private List<IndividualSoundConfig> source;
    private String lastSearchText = null;

    public IndividualSoundControlList(@Nonnull Screen parent, @Nonnull Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotWidth, int slotHeightIn, boolean enablePlay, @Nonnull Supplier<String> filter, @Nullable IndividualSoundControlList oldList) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.parent = parent;
        this.enablePlay = enablePlay;
        this.width = slotWidth;
        if (oldList != null) {
            this.source = oldList.source;
        }
        this.setSearchFilter(filter, false);
    }

    public void tick() {
        this.func_231039_at__().stream().map(IndividualSoundControlListEntry.class::cast).forEach(IndividualSoundControlListEntry::tick);
    }

    public int func_230949_c_() {
        return this.width;
    }

    protected int func_230952_d_() {
        return (this.parent.field_230708_k_ + this.func_230949_c_()) / 2 + 20;
    }

    public void setSearchFilter(@Nonnull Supplier<String> filterBy, boolean forceReload) {
        String filter = filterBy.get();
        if (!forceReload && this.lastSearchText != null && this.lastSearchText.equals(filter)) {
            return;
        }
        this.lastSearchText = filter;
        this.func_230963_j_();
        if (this.source == null || forceReload) {
            this.source = new ArrayList<IndividualSoundConfig>(SoundLibrary.getSortedSoundConfigurations());
        }
        Function<IndividualSoundConfig, Boolean> process = StringUtils.func_151246_b((String)filter) ? isc -> true : isc -> isc.getLocation().toString().contains(filter);
        IndividualSoundControlListEntry first = null;
        for (IndividualSoundConfig cfg : this.source) {
            if (!process.apply(cfg).booleanValue()) continue;
            IndividualSoundControlListEntry entry = new IndividualSoundControlListEntry(cfg, this.enablePlay);
            if (first == null) {
                first = entry;
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)entry);
        }
        if (first != null) {
            this.func_230954_d_((AbstractList.AbstractListEntry)first);
        }
    }

    @Nullable
    public IndividualSoundControlListEntry getEntryAt(int mouseX, int mouseY) {
        return (IndividualSoundControlListEntry)this.func_230933_a_(mouseX, mouseY);
    }

    @Nonnull
    protected Collection<IndividualSoundConfig> getConfigs() {
        ArrayList<IndividualSoundConfig> configs = new ArrayList<IndividualSoundConfig>();
        for (IndividualSoundConfig cfg : this.source) {
            if (cfg.isDefault()) continue;
            configs.add(cfg);
        }
        return configs;
    }

    public void saveChanges() {
        SoundLibrary.updateSoundConfigurations(this.getConfigs());
    }
}

