/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;

public class ItemCarryonEntity
extends Item {
    private static final Method initGoals = ObfuscationReflectionHelper.findMethod(MobEntity.class, (String)"func_184651_r", (Class[])new Class[0]);
    public static final String ENTITY_DATA_KEY = "entityData";

    public ItemCarryonEntity() {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName("carryon", "entity_item");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (ItemCarryonEntity.hasEntityData(stack)) {
            return new TranslationTextComponent(ItemCarryonEntity.getEntityType(stack).func_210760_d());
        }
        return new StringTextComponent("");
    }

    public static boolean hasEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74764_b(ENTITY_DATA_KEY) && tag.func_74764_b("entity");
        }
        return false;
    }

    public static boolean storeEntityData(@Nonnull Entity entity, World world, ItemStack stack) {
        CompoundNBT tag;
        if (entity == null) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        CompoundNBT entityData = new CompoundNBT();
        entityData = entity.serializeNBT();
        String name = EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString();
        CompoundNBT compoundNBT = tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        if (tag.func_74764_b(ENTITY_DATA_KEY)) {
            return false;
        }
        tag.func_218657_a(ENTITY_DATA_KEY, (INBT)entityData);
        tag.func_74778_a("entity", name);
        stack.func_77982_d(tag);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        ItemStack stack = context.func_195996_i();
        BlockState state = world.func_180495_p(pos);
        if (ModList.get().isLoaded("betterplacement") && CarryOnKeybinds.isKeyPressed(player)) {
            return ActionResultType.FAIL;
        }
        if (ItemCarryonEntity.hasEntityData(stack)) {
            Entity entity;
            BlockPos finalPos = pos;
            if (!state.func_196953_a(new BlockItemUseContext(context))) {
                finalPos = pos.func_177972_a(facing);
            }
            if ((entity = ItemCarryonEntity.getEntity(stack, world)) != null) {
                if (!world.field_72995_K) {
                    entity.func_70080_a((double)finalPos.func_177958_n() + 0.5, (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p() + 0.5, 180.0f + player.field_70759_as, 0.0f);
                    world.func_217376_c(entity);
                    if (entity instanceof MobEntity) {
                        ((MobEntity)entity).func_70642_aH();
                    }
                    ItemCarryonEntity.clearEntityData(stack);
                    player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    ItemEvents.sendPacket(player, 9, 0);
                }
                player.getPersistentData().func_82580_o("overrideKey");
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemCarryonEntity.hasEntityData(stack)) {
            if (ItemCarryonEntity.getEntity(stack, world) == null) {
                stack = ItemStack.field_190927_a;
            }
            if (entity instanceof LivingEntity) {
                if (!(entity instanceof PlayerEntity && ((Boolean)Configs.Settings.slownessInCreative.get()).booleanValue() || !((PlayerEntity)entity).func_184812_l_())) {
                    return;
                }
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 1, this.potionLevel(stack, world), false, false));
            }
        } else {
            stack = ItemStack.field_190927_a;
        }
    }

    public static void clearEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            tag.func_82580_o(ENTITY_DATA_KEY);
            tag.func_82580_o("entity");
        }
    }

    public static CompoundNBT getPersistentData(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74775_l(ENTITY_DATA_KEY);
        }
        return null;
    }

    public static Entity getEntity(ItemStack stack, World world) {
        if (world == null) {
            return null;
        }
        String name = ItemCarryonEntity.getEntityName(stack);
        CompoundNBT e = ItemCarryonEntity.getPersistentData(stack);
        Optional type = EntityType.func_220327_a((String)name);
        Entity entity = null;
        if (type.isPresent()) {
            entity = ((EntityType)type.get()).func_200721_a(world);
        }
        if (entity != null) {
            try {
                initGoals.invoke((Object)entity, new Object[0]);
                entity.deserializeNBT(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entity;
    }

    public static String getEntityName(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return tag.func_74779_i("entity");
        }
        return null;
    }

    public static String getCustomName(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag.func_74764_b("CustomName") && !tag.func_74779_i("CustomName").isEmpty()) {
                return tag.toString();
            }
            return tag.toString();
        }
        return null;
    }

    public static EntityType<?> getEntityType(ItemStack stack) {
        CompoundNBT tag;
        String name;
        Optional type;
        if (stack.func_77942_o() && (type = EntityType.func_220327_a((String)(name = (tag = stack.func_77978_p()).func_74779_i("entity")))).isPresent()) {
            return (EntityType)type.get();
        }
        return null;
    }

    private int potionLevel(ItemStack stack, World world) {
        Entity e = ItemCarryonEntity.getEntity(stack, world);
        if (e == null) {
            return 1;
        }
        int i = (int)(e.func_213302_cg() * e.func_213311_cf());
        if (i > 4) {
            i = 4;
        }
        if (!((Boolean)Configs.Settings.heavyEntities.get()).booleanValue()) {
            i = 1;
        }
        double multiplier = (Double)Configs.Settings.entitySlownessMultiplier.get();
        return (int)(multiplier * (double)i);
    }

    static {
        initGoals.setAccessible(true);
    }
}

