/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;

public class SyncKeybindPacket {
    public boolean pressed;

    public SyncKeybindPacket(ByteBuf buf) {
        this.pressed = buf.readBoolean();
    }

    public SyncKeybindPacket(boolean pressed) {
        this.pressed = pressed;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.pressed);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                CarryOnKeybinds.setKeyPressed((PlayerEntity)player, this.pressed);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

