/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.config;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.basemod.MuseLogger;
import lehjr.numina.config.ConfigHelper;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.io.FileUtils;

public class ModuleConfig
implements IConfig {
    Optional<ModConfig> serverConfig = Optional.empty();
    Map<String, Map<String, ArrayList<String>>> outputMap = new HashMap<String, Map<String, ArrayList<String>>>();
    final String MOD_ID;

    public ModuleConfig(String mod_ID) {
        this.MOD_ID = mod_ID;
    }

    @Override
    public void setServerConfig(@Nullable ModConfig serverConfig) {
        this.serverConfig = Optional.ofNullable(serverConfig);
    }

    @Override
    public Optional<ModConfig> getModConfig() {
        return this.serverConfig;
    }

    boolean isInDevMode() {
        ((ModContainer)ModList.get().getModContainerById("numina").get()).getModInfo().getModProperties();
        return ModList.get().getModContainerById("numina").map(container -> container.getModInfo().getOwningFile().getFileProperties().isEmpty()).orElse(false);
    }

    void addtoMap(String category, String moduleName, String entry) {
        if (this.serverConfig.isPresent()) {
            ArrayList moduleSettings;
            Map<Object, Object> modulesForCategory;
            MuseLogger.logDebug("adding to map: " + category + ", " + moduleName + ", " + entry);
            if (this.outputMap.containsKey(category)) {
                modulesForCategory = this.outputMap.get(category);
                if (modulesForCategory.containsKey(moduleName)) {
                    moduleSettings = (ArrayList)modulesForCategory.get(moduleName);
                    if (moduleSettings.contains(entry)) {
                        return;
                    }
                } else {
                    moduleSettings = new ArrayList();
                }
            } else {
                modulesForCategory = new HashMap();
                moduleSettings = new ArrayList();
            }
            moduleSettings.add(entry);
            modulesForCategory.put(moduleName, moduleSettings);
            this.outputMap.put(category, modulesForCategory);
        }
    }

    public void writeMissingConfigValues() {
        if (this.outputMap.isEmpty() || !this.isInDevMode()) {
            return;
        }
        this.getModConfig().ifPresent(config -> MuseLogger.logDebug("configData for " + this.MOD_ID + ": " + config.getConfigData()));
        MuseLogger.logDebug("MODULE MAP SET SIZE: " + this.outputMap.size());
        StringBuilder outString = new StringBuilder("builder.push(\"Modules\");\n");
        for (Map.Entry<String, Map<String, ArrayList<String>>> categoryMapEntry : this.outputMap.entrySet()) {
            String moduleCategory = categoryMapEntry.getKey();
            outString.append("builder.push(\"").append(moduleCategory).append("\");\n");
            Map<String, ArrayList<String>> moduleMapEntry = categoryMapEntry.getValue();
            for (Map.Entry<String, ArrayList<String>> entry : moduleMapEntry.entrySet()) {
                String moduleName = entry.getKey();
                ArrayList<String> moduleSettings = entry.getValue();
                outString.append("builder.push(\"").append(moduleName).append("\");\n");
                for (String moduleLine : moduleSettings) {
                    outString.append(moduleLine);
                }
                outString.append("builder.pop();\n");
            }
            outString.append("builder.pop();\n");
        }
        outString.append("builder.pop();\n");
        try {
            FileUtils.writeStringToFile((File)ConfigHelper.setupConfigFile("missingConfigs.txt", this.MOD_ID), (String)outString.toString(), (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public double getBasePropertyDoubleOrDefault(final ModuleCategory category, @Nonnull ItemStack module, String propertyName, double baseVal) {
        final String moduleName = this.itemTranslationKeyToConfigKey(module.func_77973_b().func_77658_a());
        final String entry = "base_" + propertyName;
        return this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                ArrayList<String> key = new ArrayList<String>(){
                    {
                        this.add("Modules");
                        this.add(category.getConfigTitle());
                        this.add(moduleName);
                        this.add(entry);
                    }
                };
                if (config.getConfigData().contains((List)key)) {
                    return (Double)config.getConfigData().get((List)key);
                }
                if (!this.isInDevMode()) {
                    config.getConfigData().set((List)key, (Object)baseVal);
                }
            }
            return baseVal;
        }).orElseGet(() -> {
            this.addtoMap(category.getConfigTitle(), moduleName, "builder.defineInRange(\"" + entry + "\", " + baseVal + "D, " + 0 + ", " + Double.MAX_VALUE + ");\n");
            this.isModuleAllowed(category, module);
            return baseVal;
        });
    }

    @Override
    public double getTradeoffPropertyDoubleOrDefault(final ModuleCategory category, @Nonnull ItemStack module, String tradeoffName, String propertyName, double multiplier) {
        final String moduleName = this.itemTranslationKeyToConfigKey(module.func_77973_b().func_77658_a());
        final String entry = propertyName + "_" + tradeoffName + "_multiplier";
        return this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                ArrayList<String> key = new ArrayList<String>(){
                    {
                        this.add("Modules");
                        this.add(category.getConfigTitle().replace(" ", "_"));
                        this.add(moduleName);
                        this.add(entry);
                    }
                };
                if (config.getConfigData().contains((List)key)) {
                    Double val = (Double)config.getConfigData().get((List)key);
                    return val != null ? val : multiplier;
                }
                if (!this.isInDevMode()) {
                    config.getConfigData().set((List)key, (Object)multiplier);
                }
            }
            return multiplier;
        }).orElseGet(() -> {
            this.addtoMap(category.getConfigTitle(), moduleName, "builder.defineInRange(\"" + entry + "\", " + multiplier + "D, " + 0 + ", " + Double.MAX_VALUE + ");\n");
            this.isModuleAllowed(category, module);
            return multiplier;
        });
    }

    @Override
    public int getTradeoffPropertyIntegerOrDefault(final ModuleCategory category, @Nonnull ItemStack module, String tradeoffName, String propertyName, int multiplier) {
        final String moduleName = this.itemTranslationKeyToConfigKey(module.func_77973_b().func_77658_a());
        final String entry = propertyName + "_" + tradeoffName + "_multiplier";
        return this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                ArrayList<String> key = new ArrayList<String>(){
                    {
                        this.add("Modules");
                        this.add(category.getConfigTitle());
                        this.add(moduleName);
                        this.add(entry);
                    }
                };
                if (config.getConfigData().contains((List)key)) {
                    return (Integer)config.getConfigData().get((List)key);
                }
                if (!this.isInDevMode()) {
                    config.getConfigData().set((List)key, (Object)multiplier);
                }
            }
            return multiplier;
        }).orElseGet(() -> {
            this.addtoMap(category.getConfigTitle(), moduleName, "builder.defineInRange(\"" + entry + "\", " + multiplier + ", " + 0 + ", " + Integer.MAX_VALUE + ");\n");
            this.isModuleAllowed(category, module);
            return multiplier;
        });
    }

    @Override
    public boolean isModuleAllowed(final ModuleCategory category, @Nonnull ItemStack module) {
        final String moduleName = this.itemTranslationKeyToConfigKey(module.func_77973_b().func_77658_a());
        final String entry = "isAllowed";
        return this.getModConfig().map(config -> {
            if (config.getConfigData() != null) {
                ArrayList<String> key = new ArrayList<String>(){
                    {
                        this.add("Modules");
                        this.add(category.getConfigTitle());
                        this.add(moduleName);
                        this.add(entry);
                    }
                };
                if (config.getConfigData().contains((List)key)) {
                    return (Boolean)config.getConfigData().get((List)key);
                }
                if (!this.isInDevMode()) {
                    config.getConfigData().set((List)key, (Object)true);
                }
            }
            return true;
        }).orElseGet(() -> {
            this.addtoMap(category.getConfigTitle(), moduleName, "builder.define(\"" + entry + "\", true);\n");
            return true;
        });
    }

    String itemTranslationKeyToConfigKey(String translationKey) {
        String itemPrefix = "item." + this.MOD_ID + ".";
        if (translationKey.startsWith(itemPrefix)) {
            translationKey = translationKey.substring(itemPrefix.length());
        }
        return translationKey.replace(".", "_");
    }
}

