/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.config;

import java.util.Optional;
import lehjr.numina.config.ClientConfig;
import lehjr.numina.config.ModuleConfig;
import lehjr.numina.config.ServerConfig;
import lehjr.numina.util.capabilities.module.powermodule.IConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.NonNullLazy;
import org.apache.commons.lang3.tuple.Pair;

public class NuminaSettings {
    public static final ClientConfig CLIENT_CONFIG;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ServerConfig SERVER_CONFIG;
    public static final ForgeConfigSpec SERVER_SPEC;
    static NonNullLazy<IConfig> moduleConfig;

    public static boolean useFovFix() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_FOV_FIX.get() : true;
    }

    public static boolean useFovFixInPrincessMode() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_FOV_FIX.get() : true;
    }

    public static boolean useFovNormalize() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_FOV_NORMALIZE.get() : false;
    }

    public static boolean fovFixDefaultState() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.FOV_FIX_DEAULT_STATE.get() : true;
    }

    public static boolean useSounds() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.USE_SOUNDS.get() : true;
    }

    public static boolean enableDebugging() {
        return CLIENT_CONFIG != null ? (Boolean)NuminaSettings.CLIENT_CONFIG.DEBUGGING_INFO.get() : false;
    }

    public static int chargingBaseMaxPower() {
        return NuminaSettings.getActiveConfig().map(config -> (Integer)ServerConfig.ARMOR_STAND_MAX_POWER.get()).orElse(10000);
    }

    static Optional<ServerConfig> getActiveConfig() {
        return Optional.ofNullable(SERVER_SPEC.isLoaded() ? SERVER_CONFIG : null);
    }

    public static IConfig getModuleConfig() {
        return (IConfig)moduleConfig.get();
    }

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT_CONFIG = (ClientConfig)clientSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER_CONFIG = (ServerConfig)serverSpecPair.getLeft();
        moduleConfig = NonNullLazy.of(() -> new ModuleConfig("numina"));
    }
}

