/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.integration.appeneng2;

import appeng.api.config.LevelEmitterMode;
import appeng.api.config.PowerUnits;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.StorageFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import appeng.core.AELog;
import appeng.core.Api;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import lehjr.numina.util.energy.ElectricItemUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;

public class TerminalHandler
implements IWirelessTermHandler {
    public static final ResourceLocation WIRELESS_TERMINAL_REG = new ResourceLocation("appliedenergistics2:wireless_terminal");
    private static final String TAG_ENCRYPTION_KEY = "encryptionKey";

    public boolean canHandle(ItemStack is) {
        return is.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iModeChangingItem -> iModeChangingItem.isModuleActiveAndOnline(WIRELESS_TERMINAL_REG)).orElse(false);
    }

    public boolean usePower(PlayerEntity player, double amount, ItemStack is) {
        int drainVal = (int)PowerUnits.AE.convertTo(PowerUnits.RF, amount);
        if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > drainVal) {
            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, drainVal, false);
            return true;
        }
        return false;
    }

    public boolean hasPower(PlayerEntity player, double amount, ItemStack is) {
        return (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > PowerUnits.AE.convertTo(PowerUnits.RF, amount);
    }

    public IConfigManager getConfigManager(ItemStack is) {
        WirelessConfig config = new WirelessConfig(is);
        config.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        config.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        config.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        config.readFromNBT(is.func_196082_o());
        return config;
    }

    public String getEncryptionKey(ItemStack item) {
        return item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).map(iModeChangingItem -> {
            ItemStack module = iModeChangingItem.getOnlineModuleOrEmpty(WIRELESS_TERMINAL_REG);
            if (!module.func_190926_b()) {
                CompoundNBT tag = TerminalHandler.openNbtData(module);
                if (tag != null) {
                    return tag.func_74779_i(TAG_ENCRYPTION_KEY);
                }
                tag = TerminalHandler.openNbtData(item);
                if (tag != null) {
                    String encKey = tag.func_74779_i(TAG_ENCRYPTION_KEY);
                    module.func_77978_p().func_74778_a(TAG_ENCRYPTION_KEY, encKey);
                    return encKey;
                }
            }
            return null;
        }).orElse(null);
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(IModeChangingItem.class::isInstance).map(IModeChangingItem.class::cast).ifPresent(iModeChangingItem -> {
            ItemStack module = iModeChangingItem.getOnlineModuleOrEmpty(WIRELESS_TERMINAL_REG);
            if (!module.func_190926_b()) {
                CompoundNBT tag = TerminalHandler.openNbtData(item);
                if (tag != null) {
                    tag.func_74778_a(TAG_ENCRYPTION_KEY, encKey);
                }
                iModeChangingItem.getOnlineModuleOrEmpty(WIRELESS_TERMINAL_REG).func_77978_p().func_74778_a(TAG_ENCRYPTION_KEY, encKey);
            }
        });
    }

    private static void registerAEHandler(TerminalHandler handler) {
        Api.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)handler);
    }

    public static void registerHandler() {
        if (ModList.get().isLoaded("appliedenergistics2")) {
            TerminalHandler handler = new TerminalHandler();
            TerminalHandler.registerAEHandler(handler);
        }
    }

    public static CompoundNBT openNbtData(ItemStack item) {
        CompoundNBT compound = item.func_196082_o();
        return compound;
    }

    class WirelessConfig
    implements IConfigManager {
        private final Map<Settings, Enum<?>> enums = new EnumMap(Settings.class);
        final ItemStack stack;

        public WirelessConfig(ItemStack itemStack) {
            this.stack = itemStack;
        }

        public Set<Settings> getSettings() {
            return this.enums.keySet();
        }

        public void registerSetting(Settings settingName, Enum<?> defaultValue) {
            if (!this.enums.containsKey(settingName)) {
                this.putSetting(settingName, defaultValue);
            }
        }

        public Enum<?> getSetting(Settings settingName) {
            if (this.enums.containsKey(settingName)) {
                return this.enums.get(settingName);
            }
            return null;
        }

        public Enum<?> putSetting(Settings settingName, Enum<?> newValue) {
            this.enums.put(settingName, newValue);
            this.writeToNBT(this.stack.func_196082_o());
            return newValue;
        }

        public void writeToNBT(CompoundNBT destination) {
            CompoundNBT tag = new CompoundNBT();
            if (destination.func_74764_b("configWirelessTerminal")) {
                tag = destination.func_74775_l("configWirelessTerminal");
            }
            for (Enum enum_ : this.enums.keySet()) {
                tag.func_74778_a(enum_.name(), this.enums.get(enum_).toString());
            }
            destination.func_218657_a("configWirelessTerminal", (INBT)tag);
        }

        public void readFromNBT(CompoundNBT src) {
            CompoundNBT tag = null;
            if (src.func_74764_b("configWirelessTerminal")) {
                tag = src.func_74775_l("configWirelessTerminal");
            }
            if (tag == null) {
                return;
            }
            for (Map.Entry<Settings, Enum<?>> entry : this.enums.entrySet()) {
                try {
                    if (!tag.func_74764_b(entry.getKey().name())) continue;
                    String value = tag.func_74779_i(entry.getKey().name());
                    if (value.equals("EXTACTABLE_ONLY")) {
                        value = StorageFilter.EXTRACTABLE_ONLY.toString();
                    } else if (value.equals("STOREABLE_AMOUNT")) {
                        value = LevelEmitterMode.STORABLE_AMOUNT.toString();
                    }
                    Enum<?> oldValue = this.enums.get(entry.getKey());
                    Object newValue = Enum.valueOf(oldValue.getClass(), value);
                    this.putSetting(entry.getKey(), (Enum<?>)newValue);
                }
                catch (IllegalArgumentException e) {
                    AELog.debug((Throwable)e);
                }
            }
        }
    }
}

