/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.basemod.NuminaObjects;
import lehjr.numina.capabilities.TileEnergyStorage;
import lehjr.numina.capabilities.TileEnergyWrapper;
import lehjr.numina.config.NuminaSettings;
import lehjr.numina.util.energy.ElectricItemUtils;
import lehjr.numina.util.tileentity.MuseTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ChargingBaseTileEntity
extends MuseTileEntity
implements ITickableTileEntity {
    private ItemStackHandler itemHandler = this.createHandler();
    private TileEnergyStorage energyStorage = this.createEnergy();
    private LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IEnergyStorage> tileEnergy = LazyOptional.of(() -> this.energyStorage);
    private TileEnergyWrapper energyWrapperStorage = this.createWrapper();
    private LazyOptional<IEnergyStorage> energyWrapper = LazyOptional.of(() -> this.energyWrapperStorage);

    public ChargingBaseTileEntity() {
        super((TileEntityType)NuminaObjects.CHARGING_BASE_TILE.get());
    }

    @Nullable
    public List<LivingEntity> getEntities() {
        List list = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.field_174879_c), entity -> entity instanceof LivingEntity);
        return list;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handler.invalidate();
        this.tileEnergy.invalidate();
    }

    public void func_73660_a() {
        BlockState newState;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List entityList = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.func_174877_v()), entity -> entity instanceof LivingEntity);
        for (LivingEntity entity2 : entityList) {
            this.sendOutPower(entity2);
        }
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state != (newState = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(this.energyWrapper.map(IEnergyStorage::getEnergyStored).orElse(0) > 0)))) {
            this.field_145850_b.func_180501_a(this.func_174877_v(), newState, 3);
        }
    }

    private void sendOutPower(LivingEntity entity) {
        this.energyWrapper.ifPresent(wrapper -> {
            int received = ElectricItemUtils.givePlayerEnergy(entity, wrapper.getEnergyStored(), false);
            if (received > 0) {
                wrapper.extractEnergy(received, false);
                this.func_70296_d();
            }
        });
    }

    @Override
    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public void func_230337_a_(BlockState stateIn, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        this.energyStorage.deserializeNBT(nbt.func_74775_l("energy"));
        super.func_230337_a_(stateIn, nbt);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        nbt.func_218657_a("energy", (INBT)this.energyStorage.serializeNBT());
        return super.func_189515_b(nbt);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ChargingBaseTileEntity.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!stack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    private TileEnergyStorage createEnergy() {
        return new TileEnergyStorage(NuminaSettings.chargingBaseMaxPower(), NuminaSettings.chargingBaseMaxPower()){

            @Override
            public void onEnergyChanged() {
                ChargingBaseTileEntity.this.func_70296_d();
            }
        };
    }

    private TileEnergyWrapper createWrapper() {
        return new TileEnergyWrapper(this.tileEnergy, this.handler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyWrapper.cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IEnergyStorage> getBatteryEnergyHandler() {
        return this.handler.map(iItemHandler -> iItemHandler.getStackInSlot(0).getCapability(CapabilityEnergy.ENERGY)).orElse(LazyOptional.empty());
    }

    public LazyOptional<IEnergyStorage> getTileEnergyHandler() {
        return this.tileEnergy;
    }
}

