/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.capabilities.inventory.modularitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import lehjr.numina.util.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.util.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.util.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.util.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import lehjr.numina.util.nbt.MuseNBTUtils;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ModularItem
extends ItemStackHandler
implements IModularItem {
    public static final String TAG_MODULES = "Modules";
    public static final String TAG_MODULE_SETTINGS = "Module Settings";
    ItemStack modularItem;
    Map<ModuleCategory, NuminaRangedWrapper> rangedWrappers;
    ModuleTarget target;

    public ModularItem(@Nonnull ItemStack modularItem, int size) {
        this(modularItem, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a));
    }

    public ModularItem(@Nonnull ItemStack modularItem, NonNullList<ItemStack> stacks) {
        super(stacks);
        this.modularItem = modularItem;
        this.rangedWrappers = new HashMap<ModuleCategory, NuminaRangedWrapper>();
    }

    @Override
    public void setRangedWrapperMap(Map<ModuleCategory, NuminaRangedWrapper> rangedWrappers) {
        this.rangedWrappers = rangedWrappers;
    }

    @Override
    public void toggleModule(ResourceLocation moduleName, boolean online) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)moduleName)) continue;
            int index = i;
            module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(m -> {
                if (m instanceof IToggleableModule) {
                    ((IToggleableModule)m).toggleModule(online);
                    this.onContentsChanged(index);
                }
            });
        }
    }

    @Nullable
    public Pair getRangeForCategory(ModuleCategory category) {
        NuminaRangedWrapper rangedWrapper = this.rangedWrappers.get((Object)category);
        if (rangedWrapper != null) {
            return rangedWrapper.getRange();
        }
        return null;
    }

    @Override
    public List<ResourceLocation> getInstalledModuleNames() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b()) continue;
            locations.add(module.func_77973_b().getRegistryName());
        }
        return locations;
    }

    @Override
    public NonNullList<ItemStack> getInstalledModulesOfType(Class<? extends IPowerModule> type) {
        NonNullList modules = NonNullList.func_191196_a();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            module.getCapability(PowerModuleCapability.POWER_MODULE).filter(type::isInstance).ifPresent(pm -> modules.add((Object)module));
        }
        return modules;
    }

    @Override
    public NonNullList<ItemStack> getInstalledModules() {
        NonNullList modules = NonNullList.func_191196_a();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b()) continue;
            modules.add((Object)module);
        }
        return modules;
    }

    @Override
    public boolean isModuleInstalled(ResourceLocation regName) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)regName)) continue;
            return true;
        }
        return false;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack module) {
        return this.getStackLimit(slot, module) > 0;
    }

    @Override
    public boolean isModuleValid(@Nonnull ItemStack module) {
        if (module.func_190926_b()) {
            return false;
        }
        return module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
            if (m.isAllowed()) {
                switch (m.getTarget()) {
                    case ALLITEMS: {
                        return true;
                    }
                    case TOOLONLY: {
                        return this.modularItem.func_77973_b() instanceof ToolItem;
                    }
                    case ARMORONLY: {
                        return this.modularItem.func_77973_b() instanceof ArmorItem;
                    }
                    case HEADONLY: {
                        return this.modularItem.func_77973_b() instanceof ArmorItem && MobEntity.func_184640_d((ItemStack)this.modularItem) == EquipmentSlotType.HEAD;
                    }
                    case TORSOONLY: {
                        return this.modularItem.func_77973_b() instanceof ArmorItem && MobEntity.func_184640_d((ItemStack)this.modularItem) == EquipmentSlotType.CHEST;
                    }
                    case LEGSONLY: {
                        return this.modularItem.func_77973_b() instanceof ArmorItem && MobEntity.func_184640_d((ItemStack)this.modularItem) == EquipmentSlotType.LEGS;
                    }
                    case FEETONLY: {
                        return this.modularItem.func_77973_b() instanceof ArmorItem && MobEntity.func_184640_d((ItemStack)this.modularItem) == EquipmentSlotType.FEET;
                    }
                }
                return false;
            }
            return false;
        }).orElse(false);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public boolean isModuleOnline(ResourceLocation moduleName) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)moduleName)) continue;
            return this.isModuleOnline(module);
        }
        return false;
    }

    public boolean isModuleOnline(ItemStack module) {
        return module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.isAllowed() && m.isModuleOnline()).orElse(false);
    }

    @Override
    @Nonnull
    public ItemStack getOnlineModuleOrEmpty(ResourceLocation moduleName) {
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)moduleName) || !module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.isAllowed() && m.isModuleOnline()).orElse(false).booleanValue()) continue;
            return module;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void tick(PlayerEntity player) {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.getStackInSlot(i).getCapability(PowerModuleCapability.POWER_MODULE).filter(IPlayerTickModule.class::isInstance).map(IPlayerTickModule.class::cast).filter(IPowerModule::isAllowed).ifPresent(m -> {
                if (m.isModuleOnline()) {
                    m.onPlayerTickActive(player, this.getModularItemStack());
                } else {
                    m.onPlayerTickInactive(player, this.getModularItemStack());
                }
            });
        }
    }

    @Override
    @Nonnull
    public ItemStack getModularItemStack() {
        return this.modularItem;
    }

    @Override
    public void updateFromNBT() {
        CompoundNBT nbt = this.getModularItemStack().func_196082_o();
        if (nbt.func_150297_b(TAG_MODULE_SETTINGS, 10)) {
            this.deserializeNBT((CompoundNBT)nbt.func_74781_a(TAG_MODULE_SETTINGS));
        }
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack module) {
        if (this.isModuleValid(module)) {
            if (this.isModuleInstalled(module.func_77973_b().getRegistryName())) {
                return 0;
            }
            ModuleCategory category = module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.getCategory()).orElse(ModuleCategory.NONE);
            NuminaRangedWrapper wrapper = this.rangedWrappers.get((Object)category);
            if (wrapper == null) {
                wrapper = this.rangedWrappers.get((Object)ModuleCategory.NONE);
            }
            if (wrapper != null && wrapper.contains(slot)) {
                return wrapper.getStackInSlot(slot).func_190926_b() ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public boolean setModuleTweakDouble(ResourceLocation moduleName, String key, double value) {
        boolean handled = false;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack module = this.getStackInSlot(i);
            if (module.func_190926_b() || !module.func_77973_b().getRegistryName().equals((Object)moduleName) || !module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                MuseNBTUtils.setModuleDoubleOrRemove(module, key, value);
                return true;
            }).orElse(false).booleanValue()) continue;
            this.onContentsChanged(i);
            handled = true;
            break;
        }
        return handled;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.modularItem.func_77983_a(TAG_MODULE_SETTINGS, (INBT)this.serializeNBT());
    }
}

