/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.capabilities.render.chameleon;

import java.util.Optional;
import javax.annotation.Nonnull;
import lehjr.numina.util.capabilities.render.chameleon.IChameleon;
import lehjr.numina.util.nbt.MuseNBTUtils;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class Chameleon
implements IChameleon,
INBTSerializable<StringNBT> {
    ResourceLocation blockRegName = Blocks.field_150350_a.getRegistryName();
    @Nonnull
    ItemStack module;

    public Chameleon(@Nonnull ItemStack module) {
        this.module = module;
        this.blockRegName = MuseNBTUtils.getModuleResourceLocation(module, "block").orElse(null);
    }

    @Override
    public Optional<ResourceLocation> getTargetBlockRegName() {
        return Optional.ofNullable(this.blockRegName);
    }

    @Override
    public Optional<Block> getTargetBlock() {
        return this.getTargetBlockRegName().map(regNane -> (Block)ForgeRegistries.BLOCKS.getValue(regNane));
    }

    @Override
    @Nonnull
    public ItemStack getStackToRender() {
        return this.getTargetBlock().map(block -> new ItemStack((IItemProvider)block.func_199767_j())).orElse(this.module);
    }

    public StringNBT serializeNBT() {
        if (this.blockRegName != null) {
            return StringNBT.func_229705_a_((String)this.blockRegName.toString());
        }
        return null;
    }

    @Override
    public void setTargetBlockByRegName(ResourceLocation regName) {
        IChameleon.super.setTargetBlockByRegName(regName);
        this.blockRegName = regName;
        this.serializeNBT();
    }

    public void deserializeNBT(StringNBT nbt) {
        if (nbt != null) {
            this.blockRegName = new ResourceLocation(nbt.func_150285_a_());
        }
    }
}

