/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.clickable;

import lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface IClickable
extends IDrawableRect {
    @Override
    default public void move(double x, double y) {
        this.move(new MusePoint2D(x, y));
    }

    @Override
    default public void move(MusePoint2D position) {
        this.setPosition(this.getPosition().plus(position));
    }

    default public boolean hitBox(double x, double y) {
        return this.containsPoint(x, y);
    }

    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public void setVisible(boolean var1);

    public boolean isVisible();

    default public void hide() {
        this.setVisible(false);
    }

    default public void show() {
        this.setVisible(true);
    }

    default public void enable() {
        this.setEnabled(true);
    }

    default public void disable() {
        this.setEnabled(false);
    }

    default public void enableAndShow() {
        this.enable();
        this.show();
    }

    default public void disableAndHide() {
        this.disable();
        this.hide();
    }

    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hitBox(mouseX, mouseY) && this.isEnabled() && this.isVisible()) {
            InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(button);
            boolean flag = Minecraft.func_71410_x().field_71474_y.field_74322_I.isActiveAndMatches(mouseKey);
            if (button == 0 || button == 1 || flag) {
                this.onPressed();
            }
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            return true;
        }
        return false;
    }

    default public void playDownSound(SoundHandler soundHandler) {
        soundHandler.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible()) {
            InputMappings.Input mouseKey = InputMappings.Type.MOUSE.func_197944_a(button);
            boolean flag = Minecraft.func_71410_x().field_71474_y.field_74322_I.isActiveAndMatches(mouseKey);
            if (button == 0 || button == 1 || flag) {
                this.onReleased();
            }
        }
        return false;
    }

    public void setOnPressed(IPressable var1);

    public void setOnReleased(IReleasable var1);

    public void onPressed();

    public void onReleased();

    @OnlyIn(value=Dist.CLIENT)
    public static interface IReleasable {
        public void onReleased(IClickable var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPressed(IClickable var1);
    }
}

