/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import lehjr.numina.util.client.gui.frame.IGuiFrame;
import lehjr.numina.util.client.gui.gemoetry.DrawableTile;
import lehjr.numina.util.client.gui.gemoetry.IDrawable;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.math.MuseMathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;

public class EntityRenderFrame
extends DrawableTile
implements IGuiFrame {
    boolean isVisible = true;
    boolean isEnabled = true;
    boolean allowDrag = false;
    boolean allowZoom = false;
    private double oldMouseX = 20.0;
    private double oldMouseY = 20.0;
    double anchorx = 0.0;
    double anchory = 0.0;
    int dragging = -1;
    double rotx = 0.0;
    double roty = 0.0;
    double offsetx = 0.0;
    double offsety = -2.5;
    float zoom = 30.0f;
    int mouseX = 0;
    int mouseY = 0;
    double guiLeft = 0.0;
    double guiTop = 0.0;
    LivingEntity livingEntity;

    public EntityRenderFrame(boolean growFromMiddle) {
        super(0.0, 0.0, 0.0, 0.0, growFromMiddle);
        this.setBackgroundColour(Colour.BLACK);
        this.setBottomBorderColour(Colour.DARK_GREY);
        this.setTopBorderColour(Colour.DARK_GREY);
    }

    public void setLivingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.dragging = button;
            this.anchorx = mouseX;
            this.anchory = mouseY;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.dragging = -1;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.containsPoint(mouseX, mouseY) && this.allowZoom) {
            this.zoom = (float)((double)this.zoom + dWheel * 2.0);
            return true;
        }
        return false;
    }

    @Override
    public void update(double mousex, double mousey) {
        if ((double)this.mouseX != mousex) {
            this.oldMouseX = this.mouseX;
        }
        this.mouseX = (int)mousex;
        if ((double)this.mouseY != mousey) {
            this.oldMouseY = this.mouseY;
        }
        this.mouseY = (int)mousey;
        if (this.allowDrag) {
            double dx = mousex - this.anchorx;
            double dy = mousey - this.anchory;
            switch (this.dragging) {
                case 0: {
                    this.rotx = MuseMathUtils.clampDouble(this.rotx + dy, -90.0, 90.0);
                    this.roty -= dx;
                    this.anchorx = mousex;
                    this.anchory = mousey;
                    break;
                }
                case 1: {
                    this.offsetx += dx;
                    this.offsety += dy;
                    this.anchorx = mousex;
                    this.anchory = mousey;
                    break;
                }
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            float mouse_x = (float)(this.guiLeft + 51.0 - this.oldMouseX);
            float mouse_y = (float)((double)((int)this.guiTop + 75 - 50) - this.oldMouseY);
            float i = (float)(this.centerx() + this.offsetx);
            float j = (float)(this.finalBottom() - 5.0 + this.offsety);
            this.renderEntityInInventory(i, j, this.zoom, mouse_x, mouse_y, this.livingEntity);
        }
    }

    public void renderEntityInInventory(float posX, float posY, float scale, float mouseX, float mouseY, LivingEntity livingEntity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_(scale, scale, scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float yBodyRot = livingEntity.field_70761_aq;
        float yRot = livingEntity.field_70177_z;
        float xRot = livingEntity.field_70125_A;
        float yHeadRotO = livingEntity.field_70758_at;
        float yHeadRot = livingEntity.field_70759_as;
        livingEntity.field_70761_aq = 180.0f + f * 20.0f;
        livingEntity.field_70177_z = 180.0f + f * 40.0f;
        livingEntity.field_70125_A = -f1 * 20.0f;
        livingEntity.field_70759_as = livingEntity.field_70177_z;
        livingEntity.field_70758_at = livingEntity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        livingEntity.field_70761_aq = yBodyRot;
        livingEntity.field_70177_z = yRot;
        livingEntity.field_70125_A = xRot;
        livingEntity.field_70758_at = yHeadRotO;
        livingEntity.field_70759_as = yHeadRot;
        RenderSystem.popMatrix();
    }

    @Override
    public float getZLevel() {
        return 0.0f;
    }

    @Override
    public IDrawable setZLevel(float zLevel) {
        return this;
    }

    @Override
    public List<ITextComponent> getToolTip(int x, int y) {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setAllowDrag(boolean allowDrag) {
        this.allowDrag = allowDrag;
    }

    public void setAllowZoom(boolean allowZoom) {
        this.allowZoom = allowZoom;
    }

    public void setOffsetx(double offsetx) {
        this.offsetx = offsetx;
    }

    public void setOffsety(double offsety) {
        this.offsety = offsety;
    }

    public void setGuiLeft(double guiLeft) {
        this.guiLeft = guiLeft;
    }

    public void setGuiTop(double guiTop) {
        this.guiTop = guiTop;
    }
}

