/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.frame;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import lehjr.numina.util.client.gui.frame.IGuiFrame;
import lehjr.numina.util.client.gui.gemoetry.IDrawableRect;
import lehjr.numina.util.client.render.NuminaRenderState;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.math.MuseMathUtils;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public interface IScrollable
extends IGuiFrame,
IDrawableRect {
    public void setTotalSize(int var1);

    public int getButtonSize();

    public void setButtonSize(int var1);

    public int getTotalSize();

    public int getCurrentScrollPixels();

    public void setCurrentScrollPixels(int var1);

    default public int getMaxScrollPixels() {
        return (int)Math.max((double)this.getTotalSize() - this.height(), 0.0);
    }

    default public double getScrollAmount() {
        return 8.0;
    }

    default public void setScrollAmount(double scrollAmount) {
        this.setCurrentScrollPixels((int)MuseMathUtils.clampDouble(scrollAmount, 0.0, this.getMaxScrollPixels()));
    }

    @Override
    default public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.containsPoint(mouseX, mouseY)) {
            this.setCurrentScrollPixels((int)MuseMathUtils.clampDouble((double)this.getCurrentScrollPixels() - dWheel * this.getScrollAmount(), 0.0, this.getMaxScrollPixels()));
            return true;
        }
        return false;
    }

    @Override
    default public boolean mouseClicked(double x, double y, int button) {
        if (this.isVisible() && this.containsPoint(x, y) && button == 0) {
            int dscroll = 0;
            if (y - this.top() < (double)this.getButtonSize() && this.getCurrentScrollPixels() > 0) {
                dscroll = (int)((double)dscroll - this.getScrollAmount());
            } else if (this.bottom() - y < (double)this.getButtonSize()) {
                dscroll = (int)((double)dscroll + this.getScrollAmount());
            }
            if (dscroll != 0) {
                this.setCurrentScrollPixels((int)MuseMathUtils.clampDouble(this.getCurrentScrollPixels() + dscroll, 0.0, this.getMaxScrollPixels()));
            }
            return true;
        }
        return false;
    }

    @Override
    default public void preRender(MatrixStack matrixStack, int mouseX, int mouseY, float frameTIme) {
        if (this.isVisible()) {
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            NuminaRenderState.glowOn();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(4, DefaultVertexFormats.field_227850_m_);
            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
            if ((double)this.getCurrentScrollPixels() + this.height() < (double)this.getTotalSize()) {
                buffer.func_227888_a_(matrix4f, (float)(this.left() + this.width() / 2.0), (float)this.bottom(), this.getZLevel()).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.left() + this.width() / 2.0 + 2.0), (float)this.bottom() - 4.0f, this.getZLevel()).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.left() + this.width() / 2.0 - 2.0), (float)this.bottom() - 4.0f, this.getZLevel()).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            }
            if (this.getCurrentScrollPixels() > 0) {
                buffer.func_227888_a_(matrix4f, (float)(this.left() + this.width() / 2.0), (float)this.top(), this.getZLevel()).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.left() + this.width() / 2.0 - 2.0), (float)this.top() + 4.0f, this.getZLevel()).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
                buffer.func_227888_a_(matrix4f, (float)(this.left() + this.width() / 2.0 + 2.0), (float)this.top() + 4.0f, this.getZLevel()).func_227885_a_(Colour.LIGHT_BLUE.r, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.b, Colour.LIGHT_BLUE.a).func_227886_a_(0xF000F0).func_181675_d();
            }
            tessellator.func_78381_a();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            NuminaRenderState.scissorsOn(this.left(), this.top(), this.width(), this.height());
        }
    }

    @Override
    default public void postRender(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            NuminaRenderState.scissorsOff();
            NuminaRenderState.glowOff();
        }
    }
}

