/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.gui.gemoetry;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.FloatBuffer;
import lehjr.numina.util.client.gui.gemoetry.DrawableRelativeRect;
import lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import lehjr.numina.util.math.Colour;
import lehjr.numina.util.math.MuseMathUtils;

public class Meter
extends DrawableRelativeRect {
    Colour meterColour;
    double value = 0.0;

    public Meter(Colour meterColourIn) {
        super(new MusePoint2D(0.0, 0.0), new MusePoint2D(0.0, 0.0), Colour.GREY.withAlpha(0.3f), Colour.BLACK.withAlpha(0.8f));
        this.setWidth(32.0);
        this.setHeight(8.0);
        this.setSecondBackgroundColour(Colour.WHITE.withAlpha(0.3f));
        this.setShrinkBorder(true);
        this.meterColour = meterColourIn;
    }

    public Meter setMeterColour(Colour meterColourIn) {
        this.meterColour = meterColourIn;
        return this;
    }

    void setUL(double x, double y) {
        this.setTop(y);
        this.setLeft(x);
    }

    @Override
    public float getCornerradius() {
        return 0.0f;
    }

    public void draw(MatrixStack matrixStack, double x, double y, float zLevel, double valueIn) {
        this.setUL(x, y);
        this.value = MuseMathUtils.clampDouble(valueIn, 0.0, 1.0);
        this.draw(matrixStack, zLevel);
    }

    FloatBuffer getMeterVertices() {
        float right = (float)(this.left() + (this.width() - 1.0) * this.value);
        return this.getVertices(this.left() + 1.0, this.top() + 1.0, right, this.bottom() - 1.0);
    }

    public void draw(MatrixStack matrixStack, float zLevel) {
        this.zLevel = zLevel;
        FloatBuffer backgroundVertices = this.getVertices(0.0);
        FloatBuffer backgroundColours = GradientAndArcCalculator.getColourGradient(this.backgroundColour, this.backgroundColour2, backgroundVertices.limit() * 4);
        this.drawBackground(matrixStack, backgroundVertices, backgroundColours);
        FloatBuffer meterVertices = this.getMeterVertices();
        this.drawBuffer(matrixStack, meterVertices, this.meterColour, 6);
        if (this.shrinkBorder) {
            backgroundVertices = this.getVertices(1.0);
        } else {
            backgroundVertices.rewind();
        }
        this.drawBorder(matrixStack, backgroundVertices);
    }
}

