/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.client.model.helper;

import com.google.common.collect.ImmutableList;
import forge.NuminaOBJLoader;
import forge.NuminaOBJModel;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import lehjr.numina.basemod.MuseLogger;
import lehjr.numina.util.client.model.obj.OBJBakedCompositeModel;
import lehjr.numina.util.client.model.obj.OBJModelConfiguration;
import lehjr.numina.util.math.Colour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.TransformationHelper;

public class ModelHelper {
    public static TransformationMatrix get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scaleX, float scaleY, float scaleZ) {
        return new TransformationMatrix(new Vector3f(transformX / 16.0f, transformY / 16.0f, transformZ / 16.0f), TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(angleX, angleY, angleZ), (boolean)true), new Vector3f(scaleX, scaleY, scaleZ), null);
    }

    public static TransformationMatrix get(float transformX, float transformY, float transformZ, float angleX, float angleY, float angleZ, float scale) {
        return ModelHelper.get(transformX, transformY, transformZ, angleX, angleY, angleZ, scale, scale, scale);
    }

    public static Function<ResourceLocation, TextureAtlasSprite> defaultTextureGetter(ResourceLocation location) {
        return Minecraft.func_71410_x().func_228015_a_(location);
    }

    public static Function<RenderMaterial, TextureAtlasSprite> whiteTextureGetter() {
        return iHateNamingPointlessVariables -> ModelLoader.White.instance();
    }

    @Nullable
    public static NuminaOBJModel getOBJModel(ResourceLocation location, int attempt) {
        NuminaOBJModel model;
        try {
            model = NuminaOBJLoader.INSTANCE.loadModel(new NuminaOBJModel.ModelSettings(location, true, true, true, true, null));
        }
        catch (Exception e) {
            if (attempt < 6) {
                model = ModelHelper.getOBJModel(location, attempt + 1);
                MuseLogger.logError("Model loading failed on attempt #" + attempt + "  :( " + location.toString());
            }
            model = null;
            MuseLogger.logError("Failed to load model. " + e);
        }
        MuseLogger.logDebug("got model");
        return model;
    }

    @Nullable
    public static OBJBakedCompositeModel loadBakedModel(IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        NuminaOBJModel model = ModelHelper.getOBJModel(modelLocation, 0);
        if (model != null) {
            OBJBakedCompositeModel bakedModel = model.bake((IModelConfiguration)new OBJModelConfiguration(modelLocation).setCombinedTransform(modelTransform), (ModelBakery)ModelLoader.instance(), (Function<RenderMaterial, TextureAtlasSprite>)ModelLoader.defaultTextureGetter(), modelTransform, overrides, modelLocation);
            return bakedModel;
        }
        return null;
    }

    public static List<BakedQuad> getColouredQuadsWithGlowAndTransform(List<BakedQuad> quadList, Colour colour, TransformationMatrix transform, boolean glow) {
        ImmutableList.Builder builder = ImmutableList.builder();
        quadList.forEach(quad -> builder.add((Object)ModelHelper.colouredQuadWithGlowAndTransform(colour, quad, !glow, transform)));
        return builder.build();
    }

    public static BakedQuad colouredQuadWithGlowAndTransform(Colour colour, BakedQuad quad, boolean applyDifuse, TransformationMatrix transform) {
        QuadTransformer transformer = new QuadTransformer(colour, transform, quad.func_187508_a(), applyDifuse);
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    public static List<BakedQuad> getColoredQuadsWithGlow(List<BakedQuad> quadList, Colour color, boolean glow) {
        ImmutableList.Builder builder = ImmutableList.builder();
        quadList.forEach(quad -> builder.add((Object)ModelHelper.colorQuad(color, quad, !glow)));
        return builder.build();
    }

    public static List<BakedQuad> getColoredQuads(List<BakedQuad> quadList, Colour color) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BakedQuad quad : quadList) {
            builder.add((Object)ModelHelper.colorQuad(color, quad, quad.func_239287_f_()));
        }
        return builder.build();
    }

    public static BakedQuad colorQuad(Colour color, BakedQuad quad, boolean applyDifuse) {
        QuadTransformer transformer = new QuadTransformer(color, quad.func_187508_a(), applyDifuse);
        quad.pipe((IVertexConsumer)transformer);
        return transformer.build();
    }

    private static class QuadTransformer
    extends VertexTransformer {
        Colour colour;
        Boolean applyDiffuse;
        TransformationMatrix transform;

        public QuadTransformer(Colour colour, TextureAtlasSprite texture, boolean applyDiffuse) {
            super((IVertexConsumer)new BakedQuadBuilder(texture));
            this.colour = colour;
            this.applyDiffuse = applyDiffuse;
        }

        public QuadTransformer(Colour colour, TransformationMatrix transform, TextureAtlasSprite texture, boolean applyDiffuse) {
            super((IVertexConsumer)new BakedQuadBuilder(texture));
            this.transform = transform;
            this.colour = colour;
            this.applyDiffuse = applyDiffuse;
        }

        public void put(int element, float ... data) {
            VertexFormatElement.Usage usage = ((VertexFormatElement)this.parent.getVertexFormat().func_227894_c_().get(element)).func_177375_c();
            if (this.colour != null && usage == VertexFormatElement.Usage.COLOR && data.length >= 4) {
                data[0] = this.colour.r;
                data[1] = this.colour.g;
                data[2] = this.colour.b;
                data[3] = this.colour.a;
                super.put(element, data);
            } else if (this.transform != null && usage == VertexFormatElement.Usage.POSITION && data.length >= 4) {
                Vector4f pos = new Vector4f(data[0], data[1], data[2], data[3]);
                this.transform.transformPosition(pos);
                data[0] = pos.func_195910_a();
                data[1] = pos.func_195913_b();
                data[2] = pos.func_195914_c();
                data[3] = pos.func_195915_d();
                this.parent.put(element, data);
            } else {
                super.put(element, data);
            }
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            super.setApplyDiffuseLighting(this.applyDiffuse != null ? this.applyDiffuse : diffuse);
        }

        public BakedQuad build() {
            return ((BakedQuadBuilder)this.parent).build();
        }
    }
}

