/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.util.energy;

import javax.annotation.Nonnull;
import lehjr.numina.basemod.NuminaObjects;
import lehjr.numina.util.energy.BlackList;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class ElectricItemUtils {
    public static int getPlayerEnergy(LivingEntity entity) {
        int avail = 0;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            avail += ElectricItemUtils.getItemEnergy(entity.func_184582_a(slot));
        }
        return avail;
    }

    public static int getMaxPlayerEnergy(LivingEntity entity) {
        int avail = 0;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            avail += ElectricItemUtils.getMaxItemEnergy(entity.func_184582_a(slot));
        }
        return avail;
    }

    @Deprecated
    public static int drainPlayerEnergy(LivingEntity entity, int drainAmount) {
        return ElectricItemUtils.drainPlayerEnergy(entity, drainAmount, false);
    }

    public static int drainPlayerEnergy(LivingEntity entity, int drainAmount, boolean simulate) {
        if (entity.field_70170_p.field_72995_K || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return drainAmount;
        }
        int drainleft = drainAmount;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (drainleft == 0) break;
            ItemStack stack = entity.func_184582_a(slot);
            drainleft -= ElectricItemUtils.drainItem(stack, drainleft, simulate);
        }
        return drainAmount - drainleft;
    }

    @Deprecated
    public static int givePlayerEnergy(LivingEntity entity, int rfToGive) {
        return ElectricItemUtils.givePlayerEnergy(entity, rfToGive, false);
    }

    public static int givePlayerEnergy(LivingEntity entity, int rfToGive, boolean simulate) {
        int rfLeft = rfToGive;
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            if (rfLeft <= 0) break;
            rfLeft -= ElectricItemUtils.chargeItem(entity.func_184582_a(slot), rfLeft, simulate);
        }
        if (rfLeft > 0 && entity instanceof PlayerEntity) {
            for (int i = 0; i < ((PlayerEntity)entity).field_71071_by.func_70302_i_() && rfLeft > 0; rfLeft -= ElectricItemUtils.chargeItem(((PlayerEntity)entity).field_71071_by.func_70301_a(i), rfLeft, simulate), ++i) {
            }
        }
        return rfToGive - rfLeft;
    }

    public static int drainItem(@Nonnull ItemStack itemStack, int drainAmount, boolean simulate) {
        if (BlackList.blacklistModIds.contains(itemStack.func_77973_b().getRegistryName().func_110624_b())) {
            return 0;
        }
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.extractEnergy(drainAmount, simulate)).orElse(0);
    }

    public static int getItemEnergy(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).filter(iEnergyStorage -> iEnergyStorage.getMaxEnergyStored() >= ElectricItemUtils.getMaxEnergyForComparison()).map(energyHandler -> energyHandler.getEnergyStored()).orElse(0);
    }

    public static int getMaxItemEnergy(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).filter(iEnergyStorage -> iEnergyStorage.getMaxEnergyStored() >= ElectricItemUtils.getMaxEnergyForComparison()).map(energyHandler -> energyHandler.getMaxEnergyStored()).orElse(0);
    }

    public static int chargeItem(@Nonnull ItemStack itemStack, int chargeAmount, boolean simulate) {
        return itemStack.getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.receiveEnergy(chargeAmount, simulate)).orElse(0);
    }

    static int getMaxEnergyForComparison() {
        return (int)(0.8 * (double)new ItemStack((IItemProvider)NuminaObjects.BASIC_BATTERY.get()).getCapability(CapabilityEnergy.ENERGY).map(energyHandler -> energyHandler.getMaxEnergyStored()).orElse(0).intValue());
    }
}

