/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.overlay;

import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.gui.overlay.LocomotiveOverlay;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Entity;

public class SteamLocomotiveOverlay
extends LocomotiveOverlay {
    public void draw() {
        Entity riding = MinecraftClient.getPlayer().getRiding();
        if (riding == null) {
            return;
        }
        if (!(riding instanceof LocomotiveSteam)) {
            return;
        }
        LocomotiveSteam loco = (LocomotiveSteam)riding;
        this.drawBackground(loco);
        this.drawGauge(-1441853441, (float)loco.getLiquidAmount() / 1000.0f, loco.getTankCapacity().Buckets(), "B");
        this.drawGauge(-1713512995, loco.getBoilerPressure(), loco.getDefinition().getMaxPSI(loco.gauge), "PSI");
        int boilerColor = -1714305259;
        if (loco.getBoilerTemperature() > 95.0f) {
            boilerColor = -1714328555;
        }
        if (loco.getBoilerTemperature() > 105.0f) {
            boilerColor = -1717432304;
        }
        this.drawGauge(boilerColor, loco.getBoilerTemperature(), 150.0f, "C");
        this.drawScalar(GuiText.LABEL_BRAKE.toString(), loco.getAirBrake() * 10.0f, 0.0f, 10.0f);
        this.drawScalar(GuiText.LABEL_THROTTLE.toString(), loco.getThrottle() * 10.0f, -10.0f, 10.0f);
        this.drawSpeedDisplay(loco, 20);
    }
}

