/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.render.ExpireableList;
import cam72cam.mod.sound.ISound;
import java.util.UUID;
import java.util.function.Function;

public class PartSound {
    private final Function<EntityMoveableRollingStock, ISound> create;
    private final ExpireableList<UUID, ISound> sounds = new ExpireableList<UUID, ISound>(){

        @Override
        public void onRemove(UUID key, ISound value) {
            value.terminate();
        }
    };

    public PartSound(Function<EntityMoveableRollingStock, ISound> create) {
        this.create = create;
    }

    public void effects(EntityMoveableRollingStock stock, boolean enabled) {
        this.effects(stock, enabled ? 1.0f : 0.0f, 1.0f);
    }

    public void effects(EntityMoveableRollingStock stock, float volume) {
        this.effects(stock, volume, 1.0f);
    }

    public void effects(EntityMoveableRollingStock stock, float volume, float pitch) {
        if (ConfigSound.soundEnabled && this.create != null) {
            ISound sound = this.sounds.get(stock.getUUID());
            if (sound == null) {
                sound = this.create.apply(stock);
                this.sounds.put(stock.getUUID(), sound);
            }
            if (volume > 0.0f) {
                sound.setPosition(stock.getPosition());
                sound.setVelocity(stock.getVelocity());
                sound.setVolume(volume);
                sound.setPitch(pitch);
                if (!sound.isPlaying()) {
                    sound.play(stock.getPosition());
                } else {
                    sound.update();
                }
            } else if (sound.isPlaying()) {
                sound.stop();
            }
        }
    }

    public void removed(EntityMoveableRollingStock stock) {
        ISound sound = this.sounds.get(stock.getUUID());
        if (sound != null) {
            sound.terminate();
        }
    }
}

