/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.CarTank;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.registry.FreightDefinition;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.fluid.Fluid;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class CarTankDefinition
extends FreightDefinition {
    private List<Fluid> fluidFilter;
    private FluidQuantity capacity;

    public CarTankDefinition(String defID, JsonObject data) throws Exception {
        this((Class<? extends CarTank>)CarTank.class, defID, data);
    }

    CarTankDefinition(Class<? extends CarTank> type, String defID, JsonObject data) throws Exception {
        super(type, defID, data);
        if (this.capacity == null) {
            this.capacity = FluidQuantity.ZERO;
        }
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject tank = data.get("tank").getAsJsonObject();
        this.capacity = FluidQuantity.FromLiters((int)Math.ceil((double)tank.get("capacity_l").getAsInt() * this.internal_inv_scale));
        if (tank.has("whitelist")) {
            this.fluidFilter = new ArrayList<Fluid>();
            for (JsonElement allowed : tank.get("whitelist").getAsJsonArray()) {
                Fluid allowedFluid = Fluid.getFluid((String)allowed.getAsString());
                if (allowedFluid == null) {
                    ImmersiveRailroading.warn((String)("Skipping unknown whitelisted fluid: " + allowed.getAsString()), (Object[])new Object[0]);
                    continue;
                }
                this.fluidFilter.add(allowedFluid);
            }
        }
    }

    @Override
    public List<String> getTooltip(Gauge gauge) {
        List<String> tips = super.getTooltip(gauge);
        tips.add(GuiText.TANK_CAPACITY_TOOLTIP.toString(this.getTankCapaity(gauge).Buckets()));
        return tips;
    }

    public FluidQuantity getTankCapaity(Gauge gauge) {
        return this.capacity.scale(gauge.scale()).min(FluidQuantity.FromBuckets(1)).roundBuckets();
    }

    public List<Fluid> getFluidFilter() {
        return this.fluidFilter;
    }
}

