/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.registry;

import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.model.SteamLocomotiveModel;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.registry.Quilling;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.mod.resource.Identifier;
import com.google.gson.JsonObject;

public class LocomotiveSteamDefinition
extends LocomotiveDefinition {
    private static Identifier default_whistle = new Identifier("immersiverailroading", "sounds/steam/default/whistle.ogg");
    private static Identifier default_idle = new Identifier("immersiverailroading", "sounds/steam/default/idle.ogg");
    private static Identifier default_chuff = new Identifier("immersiverailroading", "sounds/steam/default/chuff.ogg");
    private static Identifier default_pressure = new Identifier("immersiverailroading", "sounds/steam/default/pressure.ogg");
    private static Identifier default_bell = new Identifier("immersiverailroading", "sounds/steam/default/bell.ogg");
    public Quilling quill;
    public Identifier whistle;
    public Identifier idle;
    public Identifier chuff;
    public Identifier pressure;
    private FluidQuantity tankCapacity;
    private int maxPSI;
    private int numSlots;
    private int width;
    public boolean tender_auto_feed;
    public boolean cab_forward;

    public LocomotiveSteamDefinition(String defID, JsonObject data) throws Exception {
        super(LocomotiveSteam.class, defID, data);
        if (this.tankCapacity == null) {
            this.tankCapacity = FluidQuantity.ZERO;
        }
    }

    @Override
    public void parseJson(JsonObject data) throws Exception {
        super.parseJson(data);
        JsonObject properties = data.get("properties").getAsJsonObject();
        this.tankCapacity = FluidQuantity.FromLiters((int)Math.ceil((double)properties.get("water_capacity_l").getAsInt() * this.internal_inv_scale));
        this.maxPSI = (int)Math.ceil((double)properties.get("max_psi").getAsInt() * this.internal_inv_scale);
        JsonObject firebox = data.get("firebox").getAsJsonObject();
        this.numSlots = (int)Math.ceil((double)firebox.get("slots").getAsInt() * this.internal_inv_scale);
        this.width = (int)Math.ceil((double)firebox.get("width").getAsInt() * this.internal_inv_scale);
        this.tender_auto_feed = properties.has("tender_auto_feed") ? properties.get("tender_auto_feed").getAsBoolean() : true;
        this.cab_forward = properties.has("cab_forward") && properties.get("cab_forward").getAsBoolean();
        JsonObject sounds = data.has("sounds") ? data.get("sounds").getAsJsonObject() : null;
        this.whistle = default_whistle;
        this.idle = default_idle;
        this.chuff = default_chuff;
        this.pressure = default_pressure;
        this.bell = default_bell;
        boolean whistleSet = false;
        if (sounds != null) {
            if (sounds.has("whistle")) {
                this.whistle = new Identifier("immersiverailroading", sounds.get("whistle").getAsString()).getOrDefault(default_whistle);
                whistleSet = true;
            }
            if (sounds.has("idle")) {
                this.idle = new Identifier("immersiverailroading", sounds.get("idle").getAsString()).getOrDefault(default_idle);
            }
            if (sounds.has("chuff")) {
                this.chuff = new Identifier("immersiverailroading", sounds.get("chuff").getAsString()).getOrDefault(default_chuff);
            }
            if (sounds.has("pressure")) {
                this.pressure = new Identifier("immersiverailroading", sounds.get("pressure").getAsString()).getOrDefault(default_pressure);
            }
            if (sounds.has("bell")) {
                this.bell = new Identifier("immersiverailroading", sounds.get("bell").getAsString()).getOrDefault(default_bell);
            }
            if (sounds.has("quilling")) {
                this.quill = new Quilling(sounds.get("quilling").getAsJsonArray());
                whistleSet = true;
            }
        }
        if (!(whistleSet || this.quill != null && this.quill.canLoad())) {
            this.quill = new Quilling(new Identifier("immersiverailroading", "sounds/steam/default/quill.ogg"));
        }
    }

    @Override
    protected StockModel<?> createModel() throws Exception {
        return new SteamLocomotiveModel(this);
    }

    public SteamLocomotiveModel getModel() {
        return (SteamLocomotiveModel)super.getModel();
    }

    public FluidQuantity getTankCapacity(Gauge gauge) {
        return this.tankCapacity.scale(gauge.scale()).min(FluidQuantity.FromBuckets(1)).roundBuckets();
    }

    public int getMaxPSI(Gauge gauge) {
        return (int)Math.ceil((double)this.maxPSI * gauge.scale());
    }

    public int getInventorySize(Gauge gauge) {
        return (int)Math.ceil((double)this.numSlots * gauge.scale());
    }

    public int getInventoryWidth(Gauge gauge) {
        return (int)Math.max(3.0, Math.ceil((double)this.width * gauge.scale()));
    }
}

