/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.multiblock;

import cam72cam.immersiverailroading.render.multiblock.BoilerRollerRender;
import cam72cam.immersiverailroading.render.multiblock.CastingRender;
import cam72cam.immersiverailroading.render.multiblock.IMultiblockRender;
import cam72cam.immersiverailroading.render.multiblock.PlateRollerRender;
import cam72cam.immersiverailroading.render.multiblock.RailRollerRender;
import cam72cam.immersiverailroading.render.multiblock.SteamHammerRender;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.render.OpenGL;
import cam72cam.mod.render.StandardModel;
import java.util.HashMap;
import java.util.Map;

public class TileMultiblockRender {
    private static final Map<String, IMultiblockRender> renderers = new HashMap<String, IMultiblockRender>();

    public static StandardModel render(TileMultiblock te) {
        IMultiblockRender renderer;
        if (te.isLoaded() && te.isRender() && (renderer = renderers.get(te.getName())) != null) {
            return new StandardModel().addCustom(partialTicks -> {
                try (OpenGL.With blend = OpenGL.bool((int)3042, (boolean)false);){
                    renderer.render(te, partialTicks.floatValue());
                }
            });
        }
        return null;
    }

    static {
        renderers.put("STEAM_HAMMER", new SteamHammerRender());
        renderers.put("PLATE_MACHINE", new PlateRollerRender());
        renderers.put("RAIL_MACHINE", new RailRollerRender());
        renderers.put("BOILER_MACHINE", new BoilerRollerRender());
        renderers.put("CASTING", new CastingRender());
    }
}

