/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.client.multiplayer;

import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SUnloadChunkPacket;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.WorldLightManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPlayNetHandler.class})
public abstract class ClientPlayNetHandlerMixin
implements IClientPlayNetHandler {
    @Shadow
    private ClientWorld field_147300_g;

    @Redirect(method={"setLightData"}, at=@At(target="Lnet/minecraft/world/lighting/WorldLightManager;setData(Lnet/minecraft/world/LightType;Lnet/minecraft/util/math/SectionPos;Lnet/minecraft/world/chunk/NibbleArray;Z)V", value="INVOKE", ordinal=0))
    private void loadLightDataHook(WorldLightManager lightEngine, LightType lightType, SectionPos pos, @Nullable NibbleArray nibble, boolean trustEdges) {
        ((StarLightLightingProvider)this.field_147300_g.func_225524_e_()).clientUpdateLight(lightType, pos, nibble, trustEdges);
    }

    @Inject(method={"processChunkUnload"}, at={@At(value="RETURN")})
    private void unloadLightDataHook(SUnloadChunkPacket clientboundForgetLevelChunkPacket, CallbackInfo ci) {
        ((StarLightLightingProvider)this.field_147300_g.func_225524_e_()).clientRemoveLightData(new ChunkPos(clientboundForgetLevelChunkPacket.func_186940_a(), clientboundForgetLevelChunkPacket.func_186941_b()));
    }

    @Inject(method={"handleChunkData"}, at={@At(target="Lnet/minecraft/client/multiplayer/ClientChunkProvider;loadChunk(IILnet/minecraft/world/biome/BiomeContainer;Lnet/minecraft/network/PacketBuffer;Lnet/minecraft/nbt/CompoundNBT;IZ)Lnet/minecraft/world/chunk/Chunk;", value="INVOKE", ordinal=0, shift=At.Shift.AFTER)})
    private void postChunkLoadHook(SChunkDataPacket clientboundLevelChunkPacket, CallbackInfo ci) {
        int chunkZ;
        int chunkX = clientboundLevelChunkPacket.func_149273_e();
        Chunk chunk = (Chunk)this.field_147300_g.func_217353_a(chunkX, chunkZ = clientboundLevelChunkPacket.func_149271_f(), ChunkStatus.field_222617_m, false);
        if (chunk == null) {
            return;
        }
        ((StarLightLightingProvider)this.field_147300_g.func_225524_e_()).clientChunkLoad(new ChunkPos(chunkX, chunkZ), chunk);
    }
}

