/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.builder;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.BlockFacings;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.Shape;
import it.zerono.mods.zerocore.lib.client.render.builder.AbstractShapeBuilder;
import it.zerono.mods.zerocore.lib.client.render.builder.QuadBuilder;
import it.zerono.mods.zerocore.lib.client.render.builder.VertexBuilder;
import it.zerono.mods.zerocore.lib.data.geometry.Cuboid;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CuboidBuilder
extends AbstractShapeBuilder {
    public static final int VERTICES_COUNT = 8;
    public static final int FACES_COUNT = CodeHelper.DIRECTIONS.length;
    private final AbstractShapeBuilder.PolygonalFaceData[] _cuboidData = new AbstractShapeBuilder.PolygonalFaceData[FACES_COUNT];
    private Cuboid _cuboid;
    private BlockFacings _facesToBeRendered = BlockFacings.ALL;
    private static CuboidBuilder s_defaultBuilder = null;

    public static CuboidBuilder getDefaultBuilder() {
        if (null == s_defaultBuilder) {
            s_defaultBuilder = new CuboidBuilder(false);
        }
        return s_defaultBuilder;
    }

    public CuboidBuilder(boolean autoReset) {
        super(autoReset);
        for (int faceIndex = 0; faceIndex < this._cuboidData.length; ++faceIndex) {
            this._cuboidData[faceIndex] = new AbstractShapeBuilder.PolygonalFaceData(4);
        }
    }

    @Override
    public Shape build() {
        if (null == this._cuboid) {
            throw new IllegalStateException("No cuboid was provided!");
        }
        Shape shape = new Shape(8);
        VertexBuilder vertexBuilder = new VertexBuilder(true);
        int vidx = 0;
        for (Direction facing : CodeHelper.DIRECTIONS) {
            if (!this._facesToBeRendered.isSet(facing)) continue;
            AbstractShapeBuilder.PolygonalFaceData data = this._cuboidData[facing.func_176745_a()];
            for (int vertexIndex = data.VERTICES_COUNT - 1; vertexIndex >= 0; --vertexIndex) {
                shape.addVertex(QuadBuilder.buildSingleVertex(vidx++, vertexIndex, vertexBuilder, this._cuboid.getFace(facing), data));
            }
        }
        if (this.autoReset()) {
            this.reset();
        }
        return shape;
    }

    @Override
    public void reset() {
        this._cuboid = null;
        this._facesToBeRendered = BlockFacings.ALL;
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.reset();
        }
    }

    public CuboidBuilder setCuboid(Cuboid cuboid) {
        this._cuboid = cuboid;
        return this;
    }

    public CuboidBuilder setVisibleFaces(BlockFacings visibleFaces) {
        this._facesToBeRendered = visibleFaces;
        return this;
    }

    public CuboidBuilder setFaceVisibility(Direction face, boolean visible) {
        this._facesToBeRendered = this._facesToBeRendered.set(face, visible);
        return this;
    }

    public CuboidBuilder setColour(Colour colour) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setColour(colour);
        }
        return this;
    }

    public CuboidBuilder setColour(Direction facing, Colour colour) {
        this._cuboidData[facing.func_176745_a()].setColour(colour);
        return this;
    }

    public CuboidBuilder setColour(Direction facing, int vertexIndex, Colour colour) {
        this._cuboidData[facing.func_176745_a()].setColour(vertexIndex, colour);
        return this;
    }

    public CuboidBuilder setTexture(UV a, UV b, UV c, UV d) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setTexture(0, a);
            data.setTexture(1, b);
            data.setTexture(2, c);
            data.setTexture(3, d);
        }
        return this;
    }

    public CuboidBuilder setTexture(Direction facing, UV a, UV b, UV c, UV d) {
        AbstractShapeBuilder.PolygonalFaceData data = this._cuboidData[facing.func_176745_a()];
        data.setTexture(0, a);
        data.setTexture(1, b);
        data.setTexture(2, c);
        data.setTexture(3, d);
        return this;
    }

    public CuboidBuilder setTexture(Direction facing, int vertexIndex, UV uv) {
        AbstractShapeBuilder.PolygonalFaceData data = this._cuboidData[facing.func_176745_a()];
        data.setTexture(vertexIndex, uv);
        return this;
    }

    public CuboidBuilder setTexture(TextureAtlasSprite sprite) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setTexture(sprite);
        }
        return this;
    }

    public CuboidBuilder setTexture(ISprite sprite) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setTexture(sprite);
        }
        return this;
    }

    public CuboidBuilder setTexture(Supplier<ISprite> sprite) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setTexture(sprite);
        }
        return this;
    }

    public CuboidBuilder setTexture(Direction facing, TextureAtlasSprite sprite) {
        this._cuboidData[facing.func_176745_a()].setTexture(sprite);
        return this;
    }

    public CuboidBuilder setTexture(Direction facing, ISprite sprite) {
        this._cuboidData[facing.func_176745_a()].setTexture(sprite);
        return this;
    }

    public CuboidBuilder setTexture(Direction facing, Supplier<ISprite> sprite) {
        this._cuboidData[facing.func_176745_a()].setTexture(sprite);
        return this;
    }

    public CuboidBuilder setLightMap(LightMap lightMap) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setLightMap(lightMap);
        }
        return this;
    }

    public CuboidBuilder setLightMapCombined(int combined) {
        return this.setLightMap(new LightMap(combined));
    }

    public CuboidBuilder setLightMap(Direction facing, LightMap lightMap) {
        this._cuboidData[facing.func_176745_a()].setLightMap(lightMap);
        return this;
    }

    public CuboidBuilder setLightMapCombined(Direction facing, int combined) {
        return this.setLightMap(facing, new LightMap(combined));
    }

    public CuboidBuilder setLightMap(Direction facing, int vertexIndex, LightMap lightMap) {
        this._cuboidData[facing.func_176745_a()].setLightMap(vertexIndex, lightMap);
        return this;
    }

    public CuboidBuilder setLightMapCombined(Direction facing, int vertexIndex, int combined) {
        return this.setLightMap(facing, vertexIndex, new LightMap(combined));
    }

    public CuboidBuilder setOverlayMap(LightMap map) {
        for (AbstractShapeBuilder.PolygonalFaceData data : this._cuboidData) {
            data.setOverlayMap(map);
        }
        return this;
    }

    public CuboidBuilder setOverlayMapCombined(int combined) {
        return this.setOverlayMap(new LightMap(combined));
    }

    public CuboidBuilder setOverlayMap(Direction facing, LightMap map) {
        this._cuboidData[facing.func_176745_a()].setOverlayMap(map);
        return this;
    }

    public CuboidBuilder setOverlayMapCombined(Direction facing, int combined) {
        return this.setOverlayMap(facing, new LightMap(combined));
    }

    public CuboidBuilder setOverlayMap(Direction facing, int vertexIndex, LightMap map) {
        this._cuboidData[facing.func_176745_a()].setOverlayMap(vertexIndex, map);
        return this;
    }

    public CuboidBuilder setOverlayMapCombined(Direction facing, int vertexIndex, int combined) {
        return this.setOverlayMap(facing, vertexIndex, new LightMap(combined));
    }
}

