/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.unimi.dsi.fastutil.ints.IntComparator;
import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.util.NonNullFunction;

public class CuboidBoundingBox {
    public static final CuboidBoundingBox EMPTY = new CuboidBoundingBox(){

        @Override
        public AxisAlignedBB getAABB() {
            return CodeHelper.EMPTY_BOUNDING_BOX;
        }

        @Override
        public CuboidBoundingBox add(BlockPos position) {
            return new CuboidBoundingBox((Vector3i)position, (Vector3i)position);
        }

        @Override
        public boolean equals(Object other) {
            return other == EMPTY;
        }
    };
    private final BlockPos.Mutable _min;
    private final BlockPos.Mutable _max;
    private AxisAlignedBB _aabb;

    public CuboidBoundingBox() {
        this((Vector3i)CodeHelper.MAX_BLOCKPOS, (Vector3i)CodeHelper.MIN_BLOCKPOS);
    }

    public CuboidBoundingBox(Vector3i min, Vector3i max) {
        this._min = new BlockPos.Mutable(min.func_177958_n(), min.func_177956_o(), min.func_177952_p());
        this._max = new BlockPos.Mutable(max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public CuboidBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this._min = new BlockPos.Mutable(minX, minY, minZ);
        this._max = new BlockPos.Mutable(maxX, maxY, maxZ);
    }

    public BlockPos getMin() {
        return this._min;
    }

    public BlockPos getMax() {
        return this._max;
    }

    public AxisAlignedBB getAABB() {
        if (null == this._aabb) {
            this._aabb = new AxisAlignedBB((BlockPos)this._min, (BlockPos)this._max);
        }
        return this._aabb;
    }

    public boolean isEmpty() {
        return this == EMPTY || 0 == this._min.compareTo((Vector3i)this._max);
    }

    public CuboidBoundingBox add(BlockPos position) {
        if (position.compareTo((Vector3i)this._min) < 0) {
            this._min.func_189533_g((Vector3i)position);
            this._aabb = null;
        }
        if (position.compareTo((Vector3i)this._max) > 0) {
            this._max.func_189533_g((Vector3i)position);
            this._aabb = null;
        }
        return this;
    }

    public CuboidBoundingBox combine(CuboidBoundingBox other) {
        if (other._min.compareTo((Vector3i)this._min) < 0) {
            this._min.func_189533_g((Vector3i)other._min);
        }
        if (other._max.compareTo((Vector3i)this._max) > 0) {
            this._max.func_189533_g((Vector3i)other._max);
        }
        return this;
    }

    public boolean contains(Vector3i vec) {
        return this.contains(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this._min.func_177958_n() && x < this._max.func_177958_n() && y >= this._min.func_177956_o() && y < this._max.func_177956_o() && z >= this._min.func_177952_p() && z < this._max.func_177952_p();
    }

    public int getLengthX() {
        return this._max.func_177958_n() - this._min.func_177958_n() + 1;
    }

    public int getLengthY() {
        return this._max.func_177956_o() - this._min.func_177956_o() + 1;
    }

    public int getLengthZ() {
        return this._max.func_177952_p() - this._min.func_177952_p() + 1;
    }

    public int getVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume((BlockPos)this._min, (BlockPos)this._max);
    }

    public int getInternalVolume() {
        return this.isEmpty() ? 0 : CodeHelper.mathVolume(this._min.func_177982_a(1, 1, 1), this._max.func_177982_a(-1, -1, -1));
    }

    public BlockPos getCenter() {
        return this._min.func_177982_a(this.getLengthX() / 2, this.getLengthY() / 2, this.getLengthZ() / 2);
    }

    public int commonVertices(Vector3i position) {
        return CodeHelper.commonVertices(position, (Vector3i)this._min) + CodeHelper.commonVertices(position, (Vector3i)this._max);
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper) {
        return mapper.apply(this.getMin(), this.getMax());
    }

    public <R> R map(BiFunction<BlockPos, BlockPos, R> mapper, NonNullFunction<BlockPos, BlockPos> minRemapper, NonNullFunction<BlockPos, BlockPos> maxRemapper) {
        return mapper.apply((BlockPos)minRemapper.apply((Object)this.getMin()), (BlockPos)maxRemapper.apply((Object)this.getMax()));
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer) {
        consumer.accept(this.getMin(), this.getMax());
    }

    public void accept(BiConsumer<BlockPos, BlockPos> consumer, NonNullFunction<BlockPos, BlockPos> minRemapper, NonNullFunction<BlockPos, BlockPos> maxRemapper) {
        consumer.accept((BlockPos)minRemapper.apply((Object)this.getMin()), (BlockPos)maxRemapper.apply((Object)this.getMax()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CuboidBoundingBox)) {
            return false;
        }
        CuboidBoundingBox otherBB = (CuboidBoundingBox)other;
        return 0 == this._min.compareTo((Vector3i)otherBB._min) && 0 == this._max.compareTo((Vector3i)otherBB._max);
    }

    public int hashCode() {
        return Objects.hash(this._min, this._max);
    }

    public String toString() {
        return String.format("Bounding box %s -> %s", CodeHelper.toString((Vector3i)this._min), CodeHelper.toString((Vector3i)this._max));
    }

    private static boolean adjustPosition(BlockPos.Mutable currentPosition, BlockPos newPosition, IntComparator minMax) {
        int curX = currentPosition.func_177958_n();
        int curY = currentPosition.func_177956_o();
        int curZ = currentPosition.func_177952_p();
        int newX = minMax.compare(currentPosition.func_177958_n(), newPosition.func_177958_n());
        int newY = minMax.compare(currentPosition.func_177956_o(), newPosition.func_177956_o());
        int newZ = minMax.compare(currentPosition.func_177952_p(), newPosition.func_177952_p());
        if (newX != curX || newY != curY || newZ != curZ) {
            currentPosition.func_181079_c(newX, newY, newZ);
            return true;
        }
        return false;
    }
}

