/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotFactory;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotIndexSet;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.SlotTemplate;
import it.zerono.mods.zerocore.lib.item.inventory.container.slot.type.SlotType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ContainerFactory {
    public static final ContainerFactory EMPTY = new ContainerFactory();
    private final List<SlotFactory> _slotFactories = Lists.newArrayList();
    private final Map<Integer, SlotTemplate> _slotIndexToTemplateMap = Maps.newHashMap();
    private final Map<SlotTemplate, SlotIndexSet> _templateToIndicesMap = Maps.newHashMap();
    private Map<SlotType, List<SlotIndexSet>> _slotTypeToIndicesCache = null;
    private PlayerInventoryUsage _playPlayerInventoryUsage = PlayerInventoryUsage.None;

    public ContainerFactory() {
        this.onAddSlots();
    }

    @Deprecated
    protected void onAddSlots() {
    }

    public boolean isIndexValid(int index) {
        return this._slotIndexToTemplateMap.containsKey(index);
    }

    public Iterable<SlotFactory> getSlots() {
        return this._slotFactories;
    }

    Optional<SlotTemplate> getSlotTemplate(int index) {
        return Optional.ofNullable(this._slotIndexToTemplateMap.get(index));
    }

    public SlotType getSlotType(int index) {
        return this.getSlotTemplate(index).map(SlotTemplate::getType).orElse(SlotType.Unknown);
    }

    public boolean isSlotOfType(int index, SlotType type) {
        return type == this.getSlotType(index);
    }

    public List<SlotIndexSet> getIndicesForType(SlotType type) {
        if (null == this._slotTypeToIndicesCache || !this._slotTypeToIndicesCache.containsKey((Object)type)) {
            List<SlotIndexSet> list = this._templateToIndicesMap.entrySet().stream().filter(entry -> null != entry.getKey() && ((SlotTemplate)entry.getKey()).getType() == type).map(Map.Entry::getValue).collect(Collectors.toList());
            if (null == this._slotTypeToIndicesCache) {
                this._slotTypeToIndicesCache = Maps.newHashMap();
            }
            this._slotTypeToIndicesCache.put(type, list);
            return list;
        }
        return this._slotTypeToIndicesCache.get((Object)type);
    }

    public PlayerInventoryUsage getPlayPlayerInventoryUsage() {
        return this._playPlayerInventoryUsage;
    }

    public ContainerFactory addSlot(int inventorySlotIndex, String inventoryName, SlotTemplate template, int x, int y) {
        SlotFactory slotFactory = new SlotFactory(inventoryName, template, inventorySlotIndex, x, y);
        int slotIndex = this._slotFactories.size();
        this._slotFactories.add(slotFactory);
        this._slotIndexToTemplateMap.put(slotIndex, template);
        SlotIndexSet indexSet = this._templateToIndicesMap.get(template);
        if (null == indexSet) {
            indexSet = new SlotIndexSet(template);
            this._templateToIndicesMap.put(template, indexSet);
        }
        indexSet.addIndex(slotIndex);
        if (null != this._slotTypeToIndicesCache) {
            this._slotTypeToIndicesCache.clear();
            this._slotTypeToIndicesCache = null;
        }
        return this;
    }

    public ContainerFactory addSlotsLine(int startingInventorySlotIndex, String inventoryName, SlotTemplate template, int x, int y, int slotAmount, int horizontalOffset, int verticalOffset) {
        for (int slotIndex = startingInventorySlotIndex; slotIndex < startingInventorySlotIndex + slotAmount; ++slotIndex) {
            this.addSlot(slotIndex, inventoryName, template, x, y);
            x += horizontalOffset;
            y += verticalOffset;
        }
        return this;
    }

    public ContainerFactory addSlotsRow(int startingInventorySlotIndex, String inventoryName, SlotTemplate template, int x, int y, int slotAmount, int offset) {
        return this.addSlotsLine(startingInventorySlotIndex, inventoryName, template, x, y, slotAmount, offset, 0);
    }

    public ContainerFactory addSlotsColumn(int startingInventorySlotIndex, String inventoryName, SlotTemplate template, int x, int y, int slotAmount, int offset) {
        return this.addSlotsLine(startingInventorySlotIndex, inventoryName, template, x, y, slotAmount, 0, offset);
    }

    public ContainerFactory addSlotBox(int startingInventorySlotIndex, String inventoryName, SlotTemplate template, int x, int y, int horizontalAmount, int horizontalOffset, int verticalAmount, int verticalOffset) {
        for (int i = 0; i < verticalAmount; ++i) {
            this.addSlotsRow(startingInventorySlotIndex + i * horizontalAmount, inventoryName, template, x, y, horizontalAmount, horizontalOffset);
            y += verticalOffset;
        }
        return this;
    }

    public ContainerFactory addPlayerMainInventorySlots(int x, int y) {
        this.addSlotBox(9, "playerinventory", SlotTemplate.TEMPLATE_PLAYERINVENTORY, x, y, 9, 18, 3, 18);
        this._playPlayerInventoryUsage = PlayerInventoryUsage.MainInventory;
        return this;
    }

    public ContainerFactory addPlayerHotBarSlots(int x, int y) {
        this.addSlotsRow(0, "playerinventory", SlotTemplate.TEMPLATE_PLAYERHOTBAR, x, y, 9, 18);
        this._playPlayerInventoryUsage = PlayerInventoryUsage.HotBar;
        return this;
    }

    public ContainerFactory addStandardPlayerInventorySlots(int x, int y) {
        this.addPlayerHotBarSlots(x, y + 0);
        this.addPlayerMainInventorySlots(x, y);
        this._playPlayerInventoryUsage = PlayerInventoryUsage.Both;
        return this;
    }
}

