/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.network;

import com.google.common.collect.Sets;
import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.lib.data.nbt.INestedSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.network.IModMessage;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import it.zerono.mods.zerocore.lib.network.ModSyncableTileMessage;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.NonNullSupplier;

public class NetworkTileEntitySyncProvider
implements INetworkTileEntitySyncProvider {
    private final Supplier<IModMessage> _messageSupplier;
    private final Set<ServerPlayerEntity> _players;

    public static NetworkTileEntitySyncProvider create(BlockPos coordinates, ISyncableEntity entity) {
        return new NetworkTileEntitySyncProvider(() -> ModSyncableTileMessage.create(coordinates, entity));
    }

    public static NetworkTileEntitySyncProvider create(NonNullSupplier<BlockPos> coordinatesSupplier, INestedSyncableEntity entity) {
        return new NetworkTileEntitySyncProvider(() -> ModSyncableTileMessage.create((BlockPos)coordinatesSupplier.get(), entity));
    }

    @Override
    public void enlistForUpdates(ServerPlayerEntity player, boolean updateNow) {
        this._players.add(player);
        if (updateNow) {
            this.getUpdateMessage().ifPresent(update -> this.sendUpdate((IModMessage)update, player));
        }
    }

    @Override
    public void delistFromUpdates(ServerPlayerEntity player) {
        this._players.remove(player);
    }

    @Override
    public void sendUpdates() {
        if (!this._players.isEmpty()) {
            this.getUpdateMessage().ifPresent(update -> this._players.forEach(player -> this.sendUpdate((IModMessage)update, (ServerPlayerEntity)player)));
        }
    }

    private NetworkTileEntitySyncProvider(Supplier<IModMessage> messageSupplier) {
        this._messageSupplier = messageSupplier;
        this._players = Sets.newHashSet();
    }

    private Optional<IModMessage> getUpdateMessage() {
        return Optional.ofNullable(this._messageSupplier.get());
    }

    private void sendUpdate(IModMessage update, ServerPlayerEntity player) {
        Network.HANDLER.sendToPlayer(update, player);
    }
}

