/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transportstorage.conveyor;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.api.IBlockContainer;
import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transportstorage.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.TextGuiComponent;
import com.buuz135.industrial.gui.component.custom.TextureGuiComponent;
import com.buuz135.industrial.gui.component.custom.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.network.ConveyorSplittingSyncEntityMessage;
import com.buuz135.industrial.utils.MovementUtils;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.Tags;

public class ConveyorSplittingUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTH = VoxelShapes.func_197873_a((double)0.295, (double)0.1, (double)-0.08000000000000002, (double)0.6950000000000001, (double)0.16, (double)0.29999999999999993);
    public static VoxelShape SOUTH = VoxelShapes.func_197873_a((double)0.295, (double)0.1, (double)0.7, (double)0.6950000000000001, (double)0.16, (double)1.08);
    public static VoxelShape WEST = VoxelShapes.func_197873_a((double)-0.08, (double)0.1, (double)0.3, (double)0.3, (double)0.16, (double)0.7);
    public static VoxelShape EAST = VoxelShapes.func_197873_a((double)0.7, (double)0.1, (double)0.3, (double)1.07, (double)0.16, (double)0.7);
    public List<Integer> handlingEntities = new ArrayList<Integer>();
    private Direction nextFacing;
    private int ratio;
    private int currentRatio;

    public ConveyorSplittingUpgrade(IBlockContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
        this.nextFacing = side;
        this.ratio = 1;
        this.currentRatio = 1;
    }

    @Override
    public void handleEntity(Entity entity) {
        super.handleEntity(entity);
        if (!this.getWorld().field_72995_K && !this.getContainer().getEntityFilter().contains(entity.func_145782_y()) && this.nextFacing == this.getSide()) {
            this.handlingEntities.add(entity.func_145782_y());
            this.getContainer().getEntityFilter().add(entity.func_145782_y());
            IndustrialForegoing.NETWORK.sendToNearby(this.getContainer().getBlockWorld(), this.getPos(), 64, (Message)new ConveyorSplittingSyncEntityMessage(this.getPos(), entity.func_145782_y(), this.getSide()));
            this.findNextUpgradeAndUpdate();
        }
        if (this.handlingEntities.contains(entity.func_145782_y())) {
            MovementUtils.handleConveyorMovement(entity, this.getSide(), this.getPos(), ((ConveyorTile)this.getContainer()).getConveyorType());
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.handlingEntities.isEmpty()) {
            return;
        }
        AxisAlignedBB box = ((AxisAlignedBB)this.getWorld().func_180495_p(this.getPos()).func_196952_d((IBlockReader)this.getWorld(), this.getPos()).func_197756_d().get(0)).func_186670_a(this.getPos()).func_186662_g(0.04);
        for (Integer integer : new ArrayList<Integer>(this.handlingEntities)) {
            Entity entity = this.getWorld().func_73045_a(integer.intValue());
            if (entity == null || box.func_72326_a(entity.func_174813_aQ())) continue;
            this.handlingEntities.remove(integer);
            this.getContainer().getEntityFilter().remove(integer);
        }
    }

    @Override
    public void onUpgradeRemoved() {
        super.onUpgradeRemoved();
        if (this.nextFacing == this.getSide()) {
            this.findNextUpgradeAndUpdate();
        }
    }

    public void findNextUpgradeAndUpdate() {
        int y;
        --this.currentRatio;
        if (this.currentRatio > 0) {
            this.getContainer().requestSync();
            return;
        }
        this.currentRatio = this.ratio;
        Direction facing = this.nextFacing.func_176746_e();
        ConveyorUpgrade conveyorUpgrade = ((ConveyorTile)this.getContainer()).getUpgradeMap().get(facing);
        for (y = 0; !(conveyorUpgrade instanceof ConveyorSplittingUpgrade) && y < 10; ++y) {
            facing = facing.func_176746_e();
            conveyorUpgrade = ((ConveyorTile)this.getContainer()).getUpgradeMap().get(facing);
        }
        if (y >= 10) {
            facing = this.getSide();
        }
        ConveyorTile entityConveyor = (ConveyorTile)this.getContainer();
        for (Direction Direction2 : entityConveyor.getUpgradeMap().keySet()) {
            ConveyorUpgrade upgrade = entityConveyor.getUpgradeMap().get(Direction2);
            if (!(upgrade instanceof ConveyorSplittingUpgrade)) continue;
            ((ConveyorSplittingUpgrade)upgrade).setNextFacing(facing);
        }
        this.getContainer().requestSync();
    }

    @Override
    public boolean ignoresCollision() {
        return true;
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: 
        }
        return EAST;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT() == null ? new CompoundNBT() : super.serializeNBT();
        compound.func_74778_a("NextFacing", this.nextFacing.func_176610_l());
        compound.func_74768_a("Ratio", this.ratio);
        compound.func_74768_a("CurrentRatio", this.currentRatio);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.nextFacing = Direction.func_176739_a((String)nbt.func_74779_i("NextFacing"));
        this.ratio = nbt.func_74762_e("Ratio");
        this.currentRatio = nbt.func_74762_e("CurrentRatio");
    }

    public Direction getNextFacing() {
        return this.nextFacing;
    }

    public void setNextFacing(Direction nextFacing) {
        this.nextFacing = nextFacing;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TextureGuiComponent(20, 26, 16, 16, res, 40, 234, "splitting_ratio"));
        componentList.add(new TextGuiComponent(40, 31){

            @Override
            public String getText() {
                return TextFormatting.DARK_GRAY + (ConveyorSplittingUpgrade.this.ratio < 10 ? " " : "") + ConveyorSplittingUpgrade.this.ratio;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(0, 60, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 104, new String[]{"increase"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
        componentList.add(new TexturedStateButtonGuiComponent(1, 76, 26, 14, 14, new StateButtonInfo[]{new StateButtonInfo(0, res, 16, 104, new String[]{"decrease"})}){

            @Override
            public int getState() {
                return 0;
            }
        });
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId == 0 && this.ratio <= 64) {
            ++this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
        if (buttonId == 1 && this.ratio > 1) {
            --this.ratio;
            this.currentRatio = this.ratio;
            this.getContainer().requestSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("splitting");
        }

        @Override
        public ConveyorUpgrade create(IBlockContainer container, Direction face) {
            return new ConveyorSplittingUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_splitting_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_splitting_upgrade");
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem()).func_200472_a("IPI").func_200472_a("IDI").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('P'), (IItemProvider)ModuleTransportStorage.CONVEYOR).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150438_bZ).func_200462_a(Character.valueOf('C'), (IItemProvider)ModuleTransportStorage.CONVEYOR).func_200464_a(consumer);
        }
    }
}

